/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.route53domains.model.GlueIpListCopier;
import software.amazon.awssdk.services.route53domains.transform.NameserverMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Nameserver
implements StructuredPojo,
ToCopyableBuilder<Builder, Nameserver> {
    private final String name;
    private final List<String> glueIps;

    private Nameserver(BuilderImpl builder) {
        this.name = builder.name;
        this.glueIps = builder.glueIps;
    }

    public String name() {
        return this.name;
    }

    public List<String> glueIps() {
        return this.glueIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.glueIps() == null ? 0 : this.glueIps().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Nameserver)) {
            return false;
        }
        Nameserver other = (Nameserver)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.glueIps() == null ^ this.glueIps() == null) {
            return false;
        }
        return other.glueIps() == null || other.glueIps().equals(this.glueIps());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.glueIps() != null) {
            sb.append("GlueIps: ").append(this.glueIps()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NameserverMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> glueIps = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(Nameserver model) {
            this.setName(model.name);
            this.setGlueIps(model.glueIps);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getGlueIps() {
            return this.glueIps;
        }

        @Override
        public final Builder glueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glueIps(String ... glueIps) {
            if (this.glueIps == null) {
                this.glueIps = new SdkInternalList(glueIps.length);
            }
            for (String e : glueIps) {
                this.glueIps.add(e);
            }
            return this;
        }

        public final void setGlueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
        }

        @SafeVarargs
        public final void setGlueIps(String ... glueIps) {
            if (this.glueIps == null) {
                this.glueIps = new SdkInternalList(glueIps.length);
            }
            for (String e : glueIps) {
                this.glueIps.add(e);
            }
        }

        public Nameserver build() {
            return new Nameserver(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Nameserver> {
        public Builder name(String var1);

        public Builder glueIps(Collection<String> var1);

        public Builder glueIps(String ... var1);
    }
}

