/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.route53domains.transform.DomainSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainSummary> {
    private final String domainName;
    private final Boolean autoRenew;
    private final Boolean transferLock;
    private final Date expiry;

    private DomainSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.autoRenew = builder.autoRenew;
        this.transferLock = builder.transferLock;
        this.expiry = builder.expiry;
    }

    public String domainName() {
        return this.domainName;
    }

    public Boolean autoRenew() {
        return this.autoRenew;
    }

    public Boolean transferLock() {
        return this.transferLock;
    }

    public Date expiry() {
        return this.expiry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.autoRenew() == null ? 0 : this.autoRenew().hashCode());
        hashCode = 31 * hashCode + (this.transferLock() == null ? 0 : this.transferLock().hashCode());
        hashCode = 31 * hashCode + (this.expiry() == null ? 0 : this.expiry().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary)obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.autoRenew() == null ^ this.autoRenew() == null) {
            return false;
        }
        if (other.autoRenew() != null && !other.autoRenew().equals(this.autoRenew())) {
            return false;
        }
        if (other.transferLock() == null ^ this.transferLock() == null) {
            return false;
        }
        if (other.transferLock() != null && !other.transferLock().equals(this.transferLock())) {
            return false;
        }
        if (other.expiry() == null ^ this.expiry() == null) {
            return false;
        }
        return other.expiry() == null || other.expiry().equals(this.expiry());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.autoRenew() != null) {
            sb.append("AutoRenew: ").append(this.autoRenew()).append(",");
        }
        if (this.transferLock() != null) {
            sb.append("TransferLock: ").append(this.transferLock()).append(",");
        }
        if (this.expiry() != null) {
            sb.append("Expiry: ").append(this.expiry()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private Boolean autoRenew;
        private Boolean transferLock;
        private Date expiry;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            this.setDomainName(model.domainName);
            this.setAutoRenew(model.autoRenew);
            this.setTransferLock(model.transferLock);
            this.setExpiry(model.expiry);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final Boolean getTransferLock() {
            return this.transferLock;
        }

        @Override
        public final Builder transferLock(Boolean transferLock) {
            this.transferLock = transferLock;
            return this;
        }

        public final void setTransferLock(Boolean transferLock) {
            this.transferLock = transferLock;
        }

        public final Date getExpiry() {
            return this.expiry;
        }

        @Override
        public final Builder expiry(Date expiry) {
            this.expiry = StandardMemberCopier.copy((Date)expiry);
            return this;
        }

        public final void setExpiry(Date expiry) {
            this.expiry = StandardMemberCopier.copy((Date)expiry);
        }

        public DomainSummary build() {
            return new DomainSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainSummary> {
        public Builder domainName(String var1);

        public Builder autoRenew(Boolean var1);

        public Builder transferLock(Boolean var1);

        public Builder expiry(Date var1);
    }
}

