/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains;

import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandler;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityRequest;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityResponse;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.DomainLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.DuplicateRequestException;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusRequest;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsResponse;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailResponse;
import software.amazon.awssdk.services.route53domains.model.InvalidInputException;
import software.amazon.awssdk.services.route53domains.model.ListDomainsRequest;
import software.amazon.awssdk.services.route53domains.model.ListDomainsResponse;
import software.amazon.awssdk.services.route53domains.model.ListOperationsRequest;
import software.amazon.awssdk.services.route53domains.model.ListOperationsResponse;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.OperationLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainResponse;
import software.amazon.awssdk.services.route53domains.model.RenewDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RenewDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailRequest;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailResponse;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeRequest;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeResponse;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsException;
import software.amazon.awssdk.services.route53domains.model.TLDRulesViolationException;
import software.amazon.awssdk.services.route53domains.model.TransferDomainRequest;
import software.amazon.awssdk.services.route53domains.model.TransferDomainResponse;
import software.amazon.awssdk.services.route53domains.model.UnsupportedTLDException;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ViewBillingRequest;
import software.amazon.awssdk.services.route53domains.model.ViewBillingResponse;
import software.amazon.awssdk.services.route53domains.transform.CheckDomainAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.CheckDomainAvailabilityResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.DeleteTagsForDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DeleteTagsForDomainResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.DisableDomainAutoRenewRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DisableDomainAutoRenewResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.DisableDomainTransferLockRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DisableDomainTransferLockResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.EnableDomainAutoRenewRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.EnableDomainAutoRenewResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.EnableDomainTransferLockRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.EnableDomainTransferLockResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetContactReachabilityStatusRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetContactReachabilityStatusResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetDomainDetailRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetDomainDetailResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetDomainSuggestionsRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetDomainSuggestionsResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetOperationDetailRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetOperationDetailResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListDomainsResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListOperationsRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListOperationsResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListTagsForDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListTagsForDomainResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.RegisterDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RegisterDomainResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.RenewDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RenewDomainResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.ResendContactReachabilityEmailRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ResendContactReachabilityEmailResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.RetrieveDomainAuthCodeRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RetrieveDomainAuthCodeResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.TransferDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.TransferDomainResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainContactPrivacyRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainContactPrivacyResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainContactRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainContactResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainNameserversRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainNameserversResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateTagsForDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateTagsForDomainResponseUnmarshaller;
import software.amazon.awssdk.services.route53domains.transform.ViewBillingRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ViewBillingResponseUnmarshaller;

@SdkInternalApi
final class DefaultRoute53DomainsClient
implements Route53DomainsClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final AwsSyncClientParams clientParams;

    protected DefaultRoute53DomainsClient(AwsSyncClientParams clientParams) {
        this.clientHandler = new SdkClientHandler(new ClientHandlerParams().withClientParams(clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.clientParams = clientParams;
        this.protocolFactory = this.init();
    }

    @Override
    public CheckDomainAvailabilityResponse checkDomainAvailability(CheckDomainAvailabilityRequest checkDomainAvailabilityRequest) throws InvalidInputException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CheckDomainAvailabilityResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CheckDomainAvailabilityResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)checkDomainAvailabilityRequest).withMarshaller((Marshaller)new CheckDomainAvailabilityRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DeleteTagsForDomainResponse deleteTagsForDomain(DeleteTagsForDomainRequest deleteTagsForDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteTagsForDomainResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteTagsForDomainResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteTagsForDomainRequest).withMarshaller((Marshaller)new DeleteTagsForDomainRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DisableDomainAutoRenewResponse disableDomainAutoRenew(DisableDomainAutoRenewRequest disableDomainAutoRenewRequest) throws InvalidInputException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DisableDomainAutoRenewResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisableDomainAutoRenewResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)disableDomainAutoRenewRequest).withMarshaller((Marshaller)new DisableDomainAutoRenewRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public DisableDomainTransferLockResponse disableDomainTransferLock(DisableDomainTransferLockRequest disableDomainTransferLockRequest) throws InvalidInputException, DuplicateRequestException, TLDRulesViolationException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DisableDomainTransferLockResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DisableDomainTransferLockResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)disableDomainTransferLockRequest).withMarshaller((Marshaller)new DisableDomainTransferLockRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public EnableDomainAutoRenewResponse enableDomainAutoRenew(EnableDomainAutoRenewRequest enableDomainAutoRenewRequest) throws InvalidInputException, UnsupportedTLDException, TLDRulesViolationException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new EnableDomainAutoRenewResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EnableDomainAutoRenewResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)enableDomainAutoRenewRequest).withMarshaller((Marshaller)new EnableDomainAutoRenewRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public EnableDomainTransferLockResponse enableDomainTransferLock(EnableDomainTransferLockRequest enableDomainTransferLockRequest) throws InvalidInputException, DuplicateRequestException, TLDRulesViolationException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new EnableDomainTransferLockResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (EnableDomainTransferLockResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)enableDomainTransferLockRequest).withMarshaller((Marshaller)new EnableDomainTransferLockRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetContactReachabilityStatusResponse getContactReachabilityStatus(GetContactReachabilityStatusRequest getContactReachabilityStatusRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetContactReachabilityStatusResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetContactReachabilityStatusResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getContactReachabilityStatusRequest).withMarshaller((Marshaller)new GetContactReachabilityStatusRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetDomainDetailResponse getDomainDetail(GetDomainDetailRequest getDomainDetailRequest) throws InvalidInputException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetDomainDetailResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetDomainDetailResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getDomainDetailRequest).withMarshaller((Marshaller)new GetDomainDetailRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetDomainSuggestionsResponse getDomainSuggestions(GetDomainSuggestionsRequest getDomainSuggestionsRequest) throws InvalidInputException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetDomainSuggestionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetDomainSuggestionsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getDomainSuggestionsRequest).withMarshaller((Marshaller)new GetDomainSuggestionsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public GetOperationDetailResponse getOperationDetail(GetOperationDetailRequest getOperationDetailRequest) throws InvalidInputException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetOperationDetailResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetOperationDetailResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getOperationDetailRequest).withMarshaller((Marshaller)new GetOperationDetailRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws InvalidInputException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListDomainsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListDomainsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listDomainsRequest).withMarshaller((Marshaller)new ListDomainsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidInputException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListOperationsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListOperationsResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listOperationsRequest).withMarshaller((Marshaller)new ListOperationsRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ListTagsForDomainResponse listTagsForDomain(ListTagsForDomainRequest listTagsForDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListTagsForDomainResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTagsForDomainResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listTagsForDomainRequest).withMarshaller((Marshaller)new ListTagsForDomainRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RegisterDomainResponse registerDomain(RegisterDomainRequest registerDomainRequest) throws InvalidInputException, UnsupportedTLDException, DuplicateRequestException, TLDRulesViolationException, DomainLimitExceededException, OperationLimitExceededException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RegisterDomainResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RegisterDomainResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)registerDomainRequest).withMarshaller((Marshaller)new RegisterDomainRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RenewDomainResponse renewDomain(RenewDomainRequest renewDomainRequest) throws InvalidInputException, UnsupportedTLDException, DuplicateRequestException, TLDRulesViolationException, OperationLimitExceededException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RenewDomainResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RenewDomainResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)renewDomainRequest).withMarshaller((Marshaller)new RenewDomainRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ResendContactReachabilityEmailResponse resendContactReachabilityEmail(ResendContactReachabilityEmailRequest resendContactReachabilityEmailRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ResendContactReachabilityEmailResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ResendContactReachabilityEmailResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)resendContactReachabilityEmailRequest).withMarshaller((Marshaller)new ResendContactReachabilityEmailRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public RetrieveDomainAuthCodeResponse retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest retrieveDomainAuthCodeRequest) throws InvalidInputException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new RetrieveDomainAuthCodeResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (RetrieveDomainAuthCodeResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)retrieveDomainAuthCodeRequest).withMarshaller((Marshaller)new RetrieveDomainAuthCodeRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public TransferDomainResponse transferDomain(TransferDomainRequest transferDomainRequest) throws InvalidInputException, UnsupportedTLDException, DuplicateRequestException, TLDRulesViolationException, DomainLimitExceededException, OperationLimitExceededException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new TransferDomainResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (TransferDomainResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)transferDomainRequest).withMarshaller((Marshaller)new TransferDomainRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateDomainContactResponse updateDomainContact(UpdateDomainContactRequest updateDomainContactRequest) throws InvalidInputException, DuplicateRequestException, TLDRulesViolationException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateDomainContactResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateDomainContactResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateDomainContactRequest).withMarshaller((Marshaller)new UpdateDomainContactRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateDomainContactPrivacyResponse updateDomainContactPrivacy(UpdateDomainContactPrivacyRequest updateDomainContactPrivacyRequest) throws InvalidInputException, DuplicateRequestException, TLDRulesViolationException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateDomainContactPrivacyResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateDomainContactPrivacyResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateDomainContactPrivacyRequest).withMarshaller((Marshaller)new UpdateDomainContactPrivacyRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateDomainNameserversResponse updateDomainNameservers(UpdateDomainNameserversRequest updateDomainNameserversRequest) throws InvalidInputException, DuplicateRequestException, TLDRulesViolationException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateDomainNameserversResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateDomainNameserversResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateDomainNameserversRequest).withMarshaller((Marshaller)new UpdateDomainNameserversRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public UpdateTagsForDomainResponse updateTagsForDomain(UpdateTagsForDomainRequest updateTagsForDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTLDException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateTagsForDomainResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateTagsForDomainResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateTagsForDomainRequest).withMarshaller((Marshaller)new UpdateTagsForDomainRequestMarshaller(this.protocolFactory))));
    }

    @Override
    public ViewBillingResponse viewBilling(ViewBillingRequest viewBillingRequest) throws InvalidInputException, SdkBaseException, SdkClientException, Route53DomainsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ViewBillingResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ViewBillingResponse)((Object)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)viewBillingRequest).withMarshaller((Marshaller)new ViewBillingRequestMarshaller(this.protocolFactory))));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(Route53DomainsException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DuplicateRequest").withModeledClass(DuplicateRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidInput").withModeledClass(InvalidInputException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TLDRulesViolation").withModeledClass(TLDRulesViolationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("DomainLimitExceeded").withModeledClass(DomainLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnsupportedTLD").withModeledClass(UnsupportedTLDException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationLimitExceeded").withModeledClass(OperationLimitExceededException.class)));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }
}

