/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.ResourceTagSet;
import software.amazon.awssdk.services.route53.model.Tag;
import software.amazon.awssdk.services.route53.transform.TagUnmarshaller;

public class ResourceTagSetUnmarshaller
implements Unmarshaller<ResourceTagSet, StaxUnmarshallerContext> {
    private static ResourceTagSetUnmarshaller INSTANCE;

    public ResourceTagSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ResourceTagSet.Builder resourceTagSet = ResourceTagSet.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ResourceType", targetDepth)) {
                    resourceTagSet.resourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ResourceId", targetDepth)) {
                    resourceTagSet.resourceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    resourceTagSet.tags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                resourceTagSet.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ResourceTagSet)resourceTagSet.build();
    }

    public static ResourceTagSetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourceTagSetUnmarshaller();
        }
        return INSTANCE;
    }
}

