/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.DelegationSet;

public class DelegationSetUnmarshaller
implements Unmarshaller<DelegationSet, StaxUnmarshallerContext> {
    private static DelegationSetUnmarshaller INSTANCE;

    public DelegationSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DelegationSet.Builder delegationSet = DelegationSet.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    delegationSet.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CallerReference", targetDepth)) {
                    delegationSet.callerReference(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NameServers", targetDepth)) {
                    delegationSet.nameServers(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("NameServers/NameServer", targetDepth)) continue;
                delegationSet.nameServers(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DelegationSet)delegationSet.build();
    }

    public static DelegationSetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DelegationSetUnmarshaller();
        }
        return INSTANCE;
    }
}

