/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.route53.model.AlarmIdentifier;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.HealthCheckConfig;
import software.amazon.awssdk.util.StringInputStream;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.XmlWriter;

public class CreateHealthCheckRequestMarshaller
implements Marshaller<Request<CreateHealthCheckRequest>, CreateHealthCheckRequest> {
    public Request<CreateHealthCheckRequest> marshall(CreateHealthCheckRequest createHealthCheckRequest) {
        if (createHealthCheckRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createHealthCheckRequest, "Route53Client");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/healthcheck";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
            xmlWriter.startElement("CreateHealthCheckRequest");
            if (createHealthCheckRequest != null) {
                HealthCheckConfig healthCheckConfig;
                if (createHealthCheckRequest.callerReference() != null) {
                    xmlWriter.startElement("CallerReference").value(createHealthCheckRequest.callerReference()).endElement();
                }
                if ((healthCheckConfig = createHealthCheckRequest.healthCheckConfig()) != null) {
                    AlarmIdentifier alarmIdentifier;
                    SdkInternalList healthCheckConfigRegionsList;
                    SdkInternalList healthCheckConfigChildHealthChecksList;
                    xmlWriter.startElement("HealthCheckConfig");
                    if (healthCheckConfig.ipAddress() != null) {
                        xmlWriter.startElement("IPAddress").value(healthCheckConfig.ipAddress()).endElement();
                    }
                    if (healthCheckConfig.port() != null) {
                        xmlWriter.startElement("Port").value((Object)healthCheckConfig.port()).endElement();
                    }
                    if (healthCheckConfig.type() != null) {
                        xmlWriter.startElement("Type").value(healthCheckConfig.type()).endElement();
                    }
                    if (healthCheckConfig.resourcePath() != null) {
                        xmlWriter.startElement("ResourcePath").value(healthCheckConfig.resourcePath()).endElement();
                    }
                    if (healthCheckConfig.fullyQualifiedDomainName() != null) {
                        xmlWriter.startElement("FullyQualifiedDomainName").value(healthCheckConfig.fullyQualifiedDomainName()).endElement();
                    }
                    if (healthCheckConfig.searchString() != null) {
                        xmlWriter.startElement("SearchString").value(healthCheckConfig.searchString()).endElement();
                    }
                    if (healthCheckConfig.requestInterval() != null) {
                        xmlWriter.startElement("RequestInterval").value((Object)healthCheckConfig.requestInterval()).endElement();
                    }
                    if (healthCheckConfig.failureThreshold() != null) {
                        xmlWriter.startElement("FailureThreshold").value((Object)healthCheckConfig.failureThreshold()).endElement();
                    }
                    if (healthCheckConfig.measureLatency() != null) {
                        xmlWriter.startElement("MeasureLatency").value((Object)healthCheckConfig.measureLatency()).endElement();
                    }
                    if (healthCheckConfig.inverted() != null) {
                        xmlWriter.startElement("Inverted").value((Object)healthCheckConfig.inverted()).endElement();
                    }
                    if (healthCheckConfig.healthThreshold() != null) {
                        xmlWriter.startElement("HealthThreshold").value((Object)healthCheckConfig.healthThreshold()).endElement();
                    }
                    if (!(healthCheckConfigChildHealthChecksList = (SdkInternalList)healthCheckConfig.childHealthChecks()).isEmpty() || !healthCheckConfigChildHealthChecksList.isAutoConstruct()) {
                        xmlWriter.startElement("ChildHealthChecks");
                        for (Object healthCheckConfigChildHealthChecksListValue : healthCheckConfigChildHealthChecksList) {
                            xmlWriter.startElement("ChildHealthCheck");
                            xmlWriter.value((String)healthCheckConfigChildHealthChecksListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (healthCheckConfig.enableSNI() != null) {
                        xmlWriter.startElement("EnableSNI").value((Object)healthCheckConfig.enableSNI()).endElement();
                    }
                    if (!(healthCheckConfigRegionsList = (SdkInternalList)healthCheckConfig.regions()).isEmpty() || !healthCheckConfigRegionsList.isAutoConstruct()) {
                        xmlWriter.startElement("Regions");
                        for (String healthCheckConfigRegionsListValue : healthCheckConfigRegionsList) {
                            xmlWriter.startElement("Region");
                            xmlWriter.value(healthCheckConfigRegionsListValue);
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((alarmIdentifier = healthCheckConfig.alarmIdentifier()) != null) {
                        xmlWriter.startElement("AlarmIdentifier");
                        if (alarmIdentifier.region() != null) {
                            xmlWriter.startElement("Region").value(alarmIdentifier.region()).endElement();
                        }
                        if (alarmIdentifier.name() != null) {
                            xmlWriter.startElement("Name").value(alarmIdentifier.name()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (healthCheckConfig.insufficientDataHealthStatus() != null) {
                        xmlWriter.startElement("InsufficientDataHealthStatus").value(healthCheckConfig.insufficientDataHealthStatus()).endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

