/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.route53.model.Change;
import software.amazon.awssdk.services.route53.model.ChangeBatch;
import software.amazon.awssdk.services.route53.transform.ChangeUnmarshaller;

public class ChangeBatchUnmarshaller
implements Unmarshaller<ChangeBatch, StaxUnmarshallerContext> {
    private static ChangeBatchUnmarshaller INSTANCE;

    public ChangeBatch unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ChangeBatch.Builder changeBatch = ChangeBatch.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Comment", targetDepth)) {
                    changeBatch.comment(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Changes", targetDepth)) {
                    changeBatch.changes(new ArrayList<Change>());
                    continue;
                }
                if (!context.testExpression("Changes/Change", targetDepth)) continue;
                changeBatch.changes(ChangeUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ChangeBatch)changeBatch.build();
    }

    public static ChangeBatchUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ChangeBatchUnmarshaller();
        }
        return INSTANCE;
    }
}

