/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.services.route53.model.VPCsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListVPCAssociationAuthorizationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListVPCAssociationAuthorizationsResponse> {
    private final String hostedZoneId;
    private final String nextToken;
    private final List<VPC> vpCs;

    private ListVPCAssociationAuthorizationsResponse(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.nextToken = builder.nextToken;
        this.vpCs = builder.vpCs;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<VPC> vpCs() {
        return this.vpCs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostedZoneId() == null ? 0 : this.hostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.vpCs() == null ? 0 : this.vpCs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVPCAssociationAuthorizationsResponse)) {
            return false;
        }
        ListVPCAssociationAuthorizationsResponse other = (ListVPCAssociationAuthorizationsResponse)((Object)obj);
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.vpCs() == null ^ this.vpCs() == null) {
            return false;
        }
        return other.vpCs() == null || other.vpCs().equals(this.vpCs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.vpCs() != null) {
            sb.append("VPCs: ").append(this.vpCs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String nextToken;
        private List<VPC> vpCs = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVPCAssociationAuthorizationsResponse model) {
            this.setHostedZoneId(model.hostedZoneId);
            this.setNextToken(model.nextToken);
            this.setVPCs(model.vpCs);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VPC> getVPCs() {
            return this.vpCs;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC ... vpCs) {
            if (this.vpCs == null) {
                this.vpCs = new SdkInternalList(vpCs.length);
            }
            for (VPC e : vpCs) {
                this.vpCs.add(e);
            }
            return this;
        }

        public final void setVPCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
        }

        @SafeVarargs
        public final void setVPCs(VPC ... vpCs) {
            if (this.vpCs == null) {
                this.vpCs = new SdkInternalList(vpCs.length);
            }
            for (VPC e : vpCs) {
                this.vpCs.add(e);
            }
        }

        public ListVPCAssociationAuthorizationsResponse build() {
            return new ListVPCAssociationAuthorizationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListVPCAssociationAuthorizationsResponse> {
        public Builder hostedZoneId(String var1);

        public Builder nextToken(String var1);

        public Builder vpCs(Collection<VPC> var1);

        public Builder vpCs(VPC ... var1);
    }
}

