/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.route53.model.ResourceTagSet;
import software.amazon.awssdk.services.route53.model.ResourceTagSetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsForResourcesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTagsForResourcesResponse> {
    private final List<ResourceTagSet> resourceTagSets;

    private ListTagsForResourcesResponse(BuilderImpl builder) {
        this.resourceTagSets = builder.resourceTagSets;
    }

    public List<ResourceTagSet> resourceTagSets() {
        return this.resourceTagSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceTagSets() == null ? 0 : this.resourceTagSets().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourcesResponse)) {
            return false;
        }
        ListTagsForResourcesResponse other = (ListTagsForResourcesResponse)((Object)obj);
        if (other.resourceTagSets() == null ^ this.resourceTagSets() == null) {
            return false;
        }
        return other.resourceTagSets() == null || other.resourceTagSets().equals(this.resourceTagSets());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceTagSets() != null) {
            sb.append("ResourceTagSets: ").append(this.resourceTagSets()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ResourceTagSet> resourceTagSets = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourcesResponse model) {
            this.setResourceTagSets(model.resourceTagSets);
        }

        public final Collection<ResourceTagSet> getResourceTagSets() {
            return this.resourceTagSets;
        }

        @Override
        public final Builder resourceTagSets(Collection<ResourceTagSet> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copy(resourceTagSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagSets(ResourceTagSet ... resourceTagSets) {
            if (this.resourceTagSets == null) {
                this.resourceTagSets = new SdkInternalList(resourceTagSets.length);
            }
            for (ResourceTagSet e : resourceTagSets) {
                this.resourceTagSets.add(e);
            }
            return this;
        }

        public final void setResourceTagSets(Collection<ResourceTagSet> resourceTagSets) {
            this.resourceTagSets = ResourceTagSetListCopier.copy(resourceTagSets);
        }

        @SafeVarargs
        public final void setResourceTagSets(ResourceTagSet ... resourceTagSets) {
            if (this.resourceTagSets == null) {
                this.resourceTagSets = new SdkInternalList(resourceTagSets.length);
            }
            for (ResourceTagSet e : resourceTagSets) {
                this.resourceTagSets.add(e);
            }
        }

        public ListTagsForResourcesResponse build() {
            return new ListTagsForResourcesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTagsForResourcesResponse> {
        public Builder resourceTagSets(Collection<ResourceTagSet> var1);

        public Builder resourceTagSets(ResourceTagSet ... var1);
    }
}

