/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.HostedZonesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHostedZonesByNameResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListHostedZonesByNameResponse> {
    private final List<HostedZone> hostedZones;
    private final String dnsName;
    private final String hostedZoneId;
    private final Boolean isTruncated;
    private final String nextDNSName;
    private final String nextHostedZoneId;
    private final String maxItems;

    private ListHostedZonesByNameResponse(BuilderImpl builder) {
        this.hostedZones = builder.hostedZones;
        this.dnsName = builder.dnsName;
        this.hostedZoneId = builder.hostedZoneId;
        this.isTruncated = builder.isTruncated;
        this.nextDNSName = builder.nextDNSName;
        this.nextHostedZoneId = builder.nextHostedZoneId;
        this.maxItems = builder.maxItems;
    }

    public List<HostedZone> hostedZones() {
        return this.hostedZones;
    }

    public String dnsName() {
        return this.dnsName;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextDNSName() {
        return this.nextDNSName;
    }

    public String nextHostedZoneId() {
        return this.nextHostedZoneId;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostedZones() == null ? 0 : this.hostedZones().hashCode());
        hashCode = 31 * hashCode + (this.dnsName() == null ? 0 : this.dnsName().hashCode());
        hashCode = 31 * hashCode + (this.hostedZoneId() == null ? 0 : this.hostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.nextDNSName() == null ? 0 : this.nextDNSName().hashCode());
        hashCode = 31 * hashCode + (this.nextHostedZoneId() == null ? 0 : this.nextHostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostedZonesByNameResponse)) {
            return false;
        }
        ListHostedZonesByNameResponse other = (ListHostedZonesByNameResponse)((Object)obj);
        if (other.hostedZones() == null ^ this.hostedZones() == null) {
            return false;
        }
        if (other.hostedZones() != null && !other.hostedZones().equals(this.hostedZones())) {
            return false;
        }
        if (other.dnsName() == null ^ this.dnsName() == null) {
            return false;
        }
        if (other.dnsName() != null && !other.dnsName().equals(this.dnsName())) {
            return false;
        }
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.nextDNSName() == null ^ this.nextDNSName() == null) {
            return false;
        }
        if (other.nextDNSName() != null && !other.nextDNSName().equals(this.nextDNSName())) {
            return false;
        }
        if (other.nextHostedZoneId() == null ^ this.nextHostedZoneId() == null) {
            return false;
        }
        if (other.nextHostedZoneId() != null && !other.nextHostedZoneId().equals(this.nextHostedZoneId())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostedZones() != null) {
            sb.append("HostedZones: ").append(this.hostedZones()).append(",");
        }
        if (this.dnsName() != null) {
            sb.append("DNSName: ").append(this.dnsName()).append(",");
        }
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.nextDNSName() != null) {
            sb.append("NextDNSName: ").append(this.nextDNSName()).append(",");
        }
        if (this.nextHostedZoneId() != null) {
            sb.append("NextHostedZoneId: ").append(this.nextHostedZoneId()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<HostedZone> hostedZones = new SdkInternalList();
        private String dnsName;
        private String hostedZoneId;
        private Boolean isTruncated;
        private String nextDNSName;
        private String nextHostedZoneId;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostedZonesByNameResponse model) {
            this.setHostedZones(model.hostedZones);
            this.setDNSName(model.dnsName);
            this.setHostedZoneId(model.hostedZoneId);
            this.setIsTruncated(model.isTruncated);
            this.setNextDNSName(model.nextDNSName);
            this.setNextHostedZoneId(model.nextHostedZoneId);
            this.setMaxItems(model.maxItems);
        }

        public final Collection<HostedZone> getHostedZones() {
            return this.hostedZones;
        }

        @Override
        public final Builder hostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostedZones(HostedZone ... hostedZones) {
            if (this.hostedZones == null) {
                this.hostedZones = new SdkInternalList(hostedZones.length);
            }
            for (HostedZone e : hostedZones) {
                this.hostedZones.add(e);
            }
            return this;
        }

        public final void setHostedZones(Collection<HostedZone> hostedZones) {
            this.hostedZones = HostedZonesCopier.copy(hostedZones);
        }

        @SafeVarargs
        public final void setHostedZones(HostedZone ... hostedZones) {
            if (this.hostedZones == null) {
                this.hostedZones = new SdkInternalList(hostedZones.length);
            }
            for (HostedZone e : hostedZones) {
                this.hostedZones.add(e);
            }
        }

        public final String getDNSName() {
            return this.dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDNSName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextDNSName() {
            return this.nextDNSName;
        }

        @Override
        public final Builder nextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
            return this;
        }

        public final void setNextDNSName(String nextDNSName) {
            this.nextDNSName = nextDNSName;
        }

        public final String getNextHostedZoneId() {
            return this.nextHostedZoneId;
        }

        @Override
        public final Builder nextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
            return this;
        }

        public final void setNextHostedZoneId(String nextHostedZoneId) {
            this.nextHostedZoneId = nextHostedZoneId;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        public ListHostedZonesByNameResponse build() {
            return new ListHostedZonesByNameResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListHostedZonesByNameResponse> {
        public Builder hostedZones(Collection<HostedZone> var1);

        public Builder hostedZones(HostedZone ... var1);

        public Builder dnsName(String var1);

        public Builder hostedZoneId(String var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextDNSName(String var1);

        public Builder nextHostedZoneId(String var1);

        public Builder maxItems(String var1);
    }
}

