/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.route53.model.ErrorMessagesCopier;
import software.amazon.awssdk.services.route53.model.Route53Exception;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InvalidChangeBatchException
extends Route53Exception
implements ToCopyableBuilder<Builder, InvalidChangeBatchException> {
    private final List<String> messages;

    private InvalidChangeBatchException(BuilderImpl builder) {
        super(builder.message);
        this.messages = builder.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<String> messages() {
        return this.messages;
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> messages = new SdkInternalList();
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidChangeBatchException model) {
            this.setMessages(model.messages);
            this.message = model.getMessage();
        }

        public final Collection<String> getMessages() {
            return this.messages;
        }

        @Override
        public final Builder messages(Collection<String> messages) {
            this.messages = ErrorMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(String ... messages) {
            if (this.messages == null) {
                this.messages = new SdkInternalList(messages.length);
            }
            for (String e : messages) {
                this.messages.add(e);
            }
            return this;
        }

        public final void setMessages(Collection<String> messages) {
            this.messages = ErrorMessagesCopier.copy(messages);
        }

        @SafeVarargs
        public final void setMessages(String ... messages) {
            if (this.messages == null) {
                this.messages = new SdkInternalList(messages.length);
            }
            for (String e : messages) {
                this.messages.add(e);
            }
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public InvalidChangeBatchException build() {
            return new InvalidChangeBatchException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InvalidChangeBatchException> {
        public Builder messages(Collection<String> var1);

        public Builder messages(String ... var1);

        public Builder message(String var1);
    }
}

