/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import software.amazon.awssdk.services.route53.model.CloudWatchAlarmConfiguration;
import software.amazon.awssdk.services.route53.model.HealthCheckConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HealthCheck
implements ToCopyableBuilder<Builder, HealthCheck> {
    private final String id;
    private final String callerReference;
    private final HealthCheckConfig healthCheckConfig;
    private final Long healthCheckVersion;
    private final CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

    private HealthCheck(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.healthCheckConfig = builder.healthCheckConfig;
        this.healthCheckVersion = builder.healthCheckVersion;
        this.cloudWatchAlarmConfiguration = builder.cloudWatchAlarmConfiguration;
    }

    public String id() {
        return this.id;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public HealthCheckConfig healthCheckConfig() {
        return this.healthCheckConfig;
    }

    public Long healthCheckVersion() {
        return this.healthCheckVersion;
    }

    public CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration() {
        return this.cloudWatchAlarmConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.callerReference() == null ? 0 : this.callerReference().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckConfig() == null ? 0 : this.healthCheckConfig().hashCode());
        hashCode = 31 * hashCode + (this.healthCheckVersion() == null ? 0 : this.healthCheckVersion().hashCode());
        hashCode = 31 * hashCode + (this.cloudWatchAlarmConfiguration() == null ? 0 : this.cloudWatchAlarmConfiguration().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheck)) {
            return false;
        }
        HealthCheck other = (HealthCheck)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.healthCheckConfig() == null ^ this.healthCheckConfig() == null) {
            return false;
        }
        if (other.healthCheckConfig() != null && !other.healthCheckConfig().equals(this.healthCheckConfig())) {
            return false;
        }
        if (other.healthCheckVersion() == null ^ this.healthCheckVersion() == null) {
            return false;
        }
        if (other.healthCheckVersion() != null && !other.healthCheckVersion().equals(this.healthCheckVersion())) {
            return false;
        }
        if (other.cloudWatchAlarmConfiguration() == null ^ this.cloudWatchAlarmConfiguration() == null) {
            return false;
        }
        return other.cloudWatchAlarmConfiguration() == null || other.cloudWatchAlarmConfiguration().equals(this.cloudWatchAlarmConfiguration());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.callerReference() != null) {
            sb.append("CallerReference: ").append(this.callerReference()).append(",");
        }
        if (this.healthCheckConfig() != null) {
            sb.append("HealthCheckConfig: ").append(this.healthCheckConfig()).append(",");
        }
        if (this.healthCheckVersion() != null) {
            sb.append("HealthCheckVersion: ").append(this.healthCheckVersion()).append(",");
        }
        if (this.cloudWatchAlarmConfiguration() != null) {
            sb.append("CloudWatchAlarmConfiguration: ").append(this.cloudWatchAlarmConfiguration()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String callerReference;
        private HealthCheckConfig healthCheckConfig;
        private Long healthCheckVersion;
        private CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheck model) {
            this.setId(model.id);
            this.setCallerReference(model.callerReference);
            this.setHealthCheckConfig(model.healthCheckConfig);
            this.setHealthCheckVersion(model.healthCheckVersion);
            this.setCloudWatchAlarmConfiguration(model.cloudWatchAlarmConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final HealthCheckConfig getHealthCheckConfig() {
            return this.healthCheckConfig;
        }

        @Override
        public final Builder healthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
            return this;
        }

        public final void setHealthCheckConfig(HealthCheckConfig healthCheckConfig) {
            this.healthCheckConfig = healthCheckConfig;
        }

        public final Long getHealthCheckVersion() {
            return this.healthCheckVersion;
        }

        @Override
        public final Builder healthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
            return this;
        }

        public final void setHealthCheckVersion(Long healthCheckVersion) {
            this.healthCheckVersion = healthCheckVersion;
        }

        public final CloudWatchAlarmConfiguration getCloudWatchAlarmConfiguration() {
            return this.cloudWatchAlarmConfiguration;
        }

        @Override
        public final Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration;
            return this;
        }

        public final void setCloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration) {
            this.cloudWatchAlarmConfiguration = cloudWatchAlarmConfiguration;
        }

        public HealthCheck build() {
            return new HealthCheck(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HealthCheck> {
        public Builder id(String var1);

        public Builder callerReference(String var1);

        public Builder healthCheckConfig(HealthCheckConfig var1);

        public Builder healthCheckVersion(Long var1);

        public Builder cloudWatchAlarmConfiguration(CloudWatchAlarmConfiguration var1);
    }
}

