/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.services.route53.model.VPCsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetHostedZoneResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetHostedZoneResponse> {
    private final HostedZone hostedZone;
    private final DelegationSet delegationSet;
    private final List<VPC> vpCs;

    private GetHostedZoneResponse(BuilderImpl builder) {
        this.hostedZone = builder.hostedZone;
        this.delegationSet = builder.delegationSet;
        this.vpCs = builder.vpCs;
    }

    public HostedZone hostedZone() {
        return this.hostedZone;
    }

    public DelegationSet delegationSet() {
        return this.delegationSet;
    }

    public List<VPC> vpCs() {
        return this.vpCs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostedZone() == null ? 0 : this.hostedZone().hashCode());
        hashCode = 31 * hashCode + (this.delegationSet() == null ? 0 : this.delegationSet().hashCode());
        hashCode = 31 * hashCode + (this.vpCs() == null ? 0 : this.vpCs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneResponse)) {
            return false;
        }
        GetHostedZoneResponse other = (GetHostedZoneResponse)((Object)obj);
        if (other.hostedZone() == null ^ this.hostedZone() == null) {
            return false;
        }
        if (other.hostedZone() != null && !other.hostedZone().equals(this.hostedZone())) {
            return false;
        }
        if (other.delegationSet() == null ^ this.delegationSet() == null) {
            return false;
        }
        if (other.delegationSet() != null && !other.delegationSet().equals(this.delegationSet())) {
            return false;
        }
        if (other.vpCs() == null ^ this.vpCs() == null) {
            return false;
        }
        return other.vpCs() == null || other.vpCs().equals(this.vpCs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostedZone() != null) {
            sb.append("HostedZone: ").append(this.hostedZone()).append(",");
        }
        if (this.delegationSet() != null) {
            sb.append("DelegationSet: ").append(this.delegationSet()).append(",");
        }
        if (this.vpCs() != null) {
            sb.append("VPCs: ").append(this.vpCs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private HostedZone hostedZone;
        private DelegationSet delegationSet;
        private List<VPC> vpCs = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneResponse model) {
            this.setHostedZone(model.hostedZone);
            this.setDelegationSet(model.delegationSet);
            this.setVPCs(model.vpCs);
        }

        public final HostedZone getHostedZone() {
            return this.hostedZone;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
        }

        public final DelegationSet getDelegationSet() {
            return this.delegationSet;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
        }

        public final Collection<VPC> getVPCs() {
            return this.vpCs;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC ... vpCs) {
            if (this.vpCs == null) {
                this.vpCs = new SdkInternalList(vpCs.length);
            }
            for (VPC e : vpCs) {
                this.vpCs.add(e);
            }
            return this;
        }

        public final void setVPCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
        }

        @SafeVarargs
        public final void setVPCs(VPC ... vpCs) {
            if (this.vpCs == null) {
                this.vpCs = new SdkInternalList(vpCs.length);
            }
            for (VPC e : vpCs) {
                this.vpCs.add(e);
            }
        }

        public GetHostedZoneResponse build() {
            return new GetHostedZoneResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetHostedZoneResponse> {
        public Builder hostedZone(HostedZone var1);

        public Builder delegationSet(DelegationSet var1);

        public Builder vpCs(Collection<VPC> var1);

        public Builder vpCs(VPC ... var1);
    }
}

