/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.route53.model.DelegationSetNameServersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DelegationSet
implements ToCopyableBuilder<Builder, DelegationSet> {
    private final String id;
    private final String callerReference;
    private final List<String> nameServers;

    private DelegationSet(BuilderImpl builder) {
        this.id = builder.id;
        this.callerReference = builder.callerReference;
        this.nameServers = builder.nameServers;
    }

    public String id() {
        return this.id;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public List<String> nameServers() {
        return this.nameServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.callerReference() == null ? 0 : this.callerReference().hashCode());
        hashCode = 31 * hashCode + (this.nameServers() == null ? 0 : this.nameServers().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelegationSet)) {
            return false;
        }
        DelegationSet other = (DelegationSet)obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.nameServers() == null ^ this.nameServers() == null) {
            return false;
        }
        return other.nameServers() == null || other.nameServers().equals(this.nameServers());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.callerReference() != null) {
            sb.append("CallerReference: ").append(this.callerReference()).append(",");
        }
        if (this.nameServers() != null) {
            sb.append("NameServers: ").append(this.nameServers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String id;
        private String callerReference;
        private List<String> nameServers = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DelegationSet model) {
            this.setId(model.id);
            this.setCallerReference(model.callerReference);
            this.setNameServers(model.nameServers);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final Collection<String> getNameServers() {
            return this.nameServers;
        }

        @Override
        public final Builder nameServers(Collection<String> nameServers) {
            this.nameServers = DelegationSetNameServersCopier.copy(nameServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameServers(String ... nameServers) {
            if (this.nameServers == null) {
                this.nameServers = new SdkInternalList(nameServers.length);
            }
            for (String e : nameServers) {
                this.nameServers.add(e);
            }
            return this;
        }

        public final void setNameServers(Collection<String> nameServers) {
            this.nameServers = DelegationSetNameServersCopier.copy(nameServers);
        }

        @SafeVarargs
        public final void setNameServers(String ... nameServers) {
            if (this.nameServers == null) {
                this.nameServers = new SdkInternalList(nameServers.length);
            }
            for (String e : nameServers) {
                this.nameServers.add(e);
            }
        }

        public DelegationSet build() {
            return new DelegationSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DelegationSet> {
        public Builder id(String var1);

        public Builder callerReference(String var1);

        public Builder nameServers(Collection<String> var1);

        public Builder nameServers(String ... var1);
    }
}

