/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.CertificateField;
import software.amazon.awssdk.services.rolesanywhere.model.MappingRule;
import software.amazon.awssdk.services.rolesanywhere.model.MappingRulesCopier;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAttributeMappingRequest
extends RolesAnywhereRequest
implements ToCopyableBuilder<Builder, PutAttributeMappingRequest> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileId").getter(PutAttributeMappingRequest.getter(PutAttributeMappingRequest::profileId)).setter(PutAttributeMappingRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileId").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateField").getter(PutAttributeMappingRequest.getter(PutAttributeMappingRequest::certificateFieldAsString)).setter(PutAttributeMappingRequest.setter(Builder::certificateField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateField").build()}).build();
    private static final SdkField<List<MappingRule>> MAPPING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mappingRules").getter(PutAttributeMappingRequest.getter(PutAttributeMappingRequest::mappingRules)).setter(PutAttributeMappingRequest.setter(Builder::mappingRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappingRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MappingRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, CERTIFICATE_FIELD_FIELD, MAPPING_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAttributeMappingRequest.memberNameToFieldInitializer();
    private final String profileId;
    private final String certificateField;
    private final List<MappingRule> mappingRules;

    private PutAttributeMappingRequest(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.certificateField = builder.certificateField;
        this.mappingRules = builder.mappingRules;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final CertificateField certificateField() {
        return CertificateField.fromValue(this.certificateField);
    }

    public final String certificateFieldAsString() {
        return this.certificateField;
    }

    public final boolean hasMappingRules() {
        return this.mappingRules != null && !(this.mappingRules instanceof SdkAutoConstructList);
    }

    public final List<MappingRule> mappingRules() {
        return this.mappingRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateFieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMappingRules() ? this.mappingRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAttributeMappingRequest)) {
            return false;
        }
        PutAttributeMappingRequest other = (PutAttributeMappingRequest)((Object)obj);
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.certificateFieldAsString(), other.certificateFieldAsString()) && this.hasMappingRules() == other.hasMappingRules() && Objects.equals(this.mappingRules(), other.mappingRules());
    }

    public final String toString() {
        return ToString.builder((String)"PutAttributeMappingRequest").add("ProfileId", (Object)this.profileId()).add("CertificateField", (Object)this.certificateFieldAsString()).add("MappingRules", this.hasMappingRules() ? this.mappingRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "profileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "certificateField": {
                return Optional.ofNullable(clazz.cast(this.certificateFieldAsString()));
            }
            case "mappingRules": {
                return Optional.ofNullable(clazz.cast(this.mappingRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("profileId", PROFILE_ID_FIELD);
        map.put("certificateField", CERTIFICATE_FIELD_FIELD);
        map.put("mappingRules", MAPPING_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAttributeMappingRequest, T> g) {
        return obj -> g.apply((PutAttributeMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereRequest.BuilderImpl
    implements Builder {
        private String profileId;
        private String certificateField;
        private List<MappingRule> mappingRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAttributeMappingRequest model) {
            super(model);
            this.profileId(model.profileId);
            this.certificateField(model.certificateField);
            this.mappingRules(model.mappingRules);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getCertificateField() {
            return this.certificateField;
        }

        public final void setCertificateField(String certificateField) {
            this.certificateField = certificateField;
        }

        @Override
        public final Builder certificateField(String certificateField) {
            this.certificateField = certificateField;
            return this;
        }

        @Override
        public final Builder certificateField(CertificateField certificateField) {
            this.certificateField(certificateField == null ? null : certificateField.toString());
            return this;
        }

        public final List<MappingRule.Builder> getMappingRules() {
            List<MappingRule.Builder> result = MappingRulesCopier.copyToBuilder(this.mappingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappingRules(Collection<MappingRule.BuilderImpl> mappingRules) {
            this.mappingRules = MappingRulesCopier.copyFromBuilder(mappingRules);
        }

        @Override
        public final Builder mappingRules(Collection<MappingRule> mappingRules) {
            this.mappingRules = MappingRulesCopier.copy(mappingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappingRules(MappingRule ... mappingRules) {
            this.mappingRules(Arrays.asList(mappingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mappingRules(Consumer<MappingRule.Builder> ... mappingRules) {
            this.mappingRules(Stream.of(mappingRules).map(c -> (MappingRule)((MappingRule.Builder)MappingRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAttributeMappingRequest build() {
            return new PutAttributeMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RolesAnywhereRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAttributeMappingRequest> {
        public Builder profileId(String var1);

        public Builder certificateField(String var1);

        public Builder certificateField(CertificateField var1);

        public Builder mappingRules(Collection<MappingRule> var1);

        public Builder mappingRules(MappingRule ... var1);

        public Builder mappingRules(Consumer<MappingRule.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

