/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.ManagedPolicyListCopier;
import software.amazon.awssdk.services.rolesanywhere.model.RoleArnListCopier;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereRequest;
import software.amazon.awssdk.services.rolesanywhere.model.Tag;
import software.amazon.awssdk.services.rolesanywhere.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProfileRequest
extends RolesAnywhereRequest
implements ToCopyableBuilder<Builder, CreateProfileRequest> {
    private static final SdkField<Boolean> ACCEPT_ROLE_SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("acceptRoleSessionName").getter(CreateProfileRequest.getter(CreateProfileRequest::acceptRoleSessionName)).setter(CreateProfileRequest.setter(Builder::acceptRoleSessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptRoleSessionName").build()}).build();
    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("durationSeconds").getter(CreateProfileRequest.getter(CreateProfileRequest::durationSeconds)).setter(CreateProfileRequest.setter(Builder::durationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationSeconds").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(CreateProfileRequest.getter(CreateProfileRequest::enabled)).setter(CreateProfileRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<List<String>> MANAGED_POLICY_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedPolicyArns").getter(CreateProfileRequest.getter(CreateProfileRequest::managedPolicyArns)).setter(CreateProfileRequest.setter(Builder::managedPolicyArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedPolicyArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateProfileRequest.getter(CreateProfileRequest::name)).setter(CreateProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> REQUIRE_INSTANCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("requireInstanceProperties").getter(CreateProfileRequest.getter(CreateProfileRequest::requireInstanceProperties)).setter(CreateProfileRequest.setter(Builder::requireInstanceProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requireInstanceProperties").build()}).build();
    private static final SdkField<List<String>> ROLE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("roleArns").getter(CreateProfileRequest.getter(CreateProfileRequest::roleArns)).setter(CreateProfileRequest.setter(Builder::roleArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SESSION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionPolicy").getter(CreateProfileRequest.getter(CreateProfileRequest::sessionPolicy)).setter(CreateProfileRequest.setter(Builder::sessionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionPolicy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateProfileRequest.getter(CreateProfileRequest::tags)).setter(CreateProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_ROLE_SESSION_NAME_FIELD, DURATION_SECONDS_FIELD, ENABLED_FIELD, MANAGED_POLICY_ARNS_FIELD, NAME_FIELD, REQUIRE_INSTANCE_PROPERTIES_FIELD, ROLE_ARNS_FIELD, SESSION_POLICY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProfileRequest.memberNameToFieldInitializer();
    private final Boolean acceptRoleSessionName;
    private final Integer durationSeconds;
    private final Boolean enabled;
    private final List<String> managedPolicyArns;
    private final String name;
    private final Boolean requireInstanceProperties;
    private final List<String> roleArns;
    private final String sessionPolicy;
    private final List<Tag> tags;

    private CreateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.acceptRoleSessionName = builder.acceptRoleSessionName;
        this.durationSeconds = builder.durationSeconds;
        this.enabled = builder.enabled;
        this.managedPolicyArns = builder.managedPolicyArns;
        this.name = builder.name;
        this.requireInstanceProperties = builder.requireInstanceProperties;
        this.roleArns = builder.roleArns;
        this.sessionPolicy = builder.sessionPolicy;
        this.tags = builder.tags;
    }

    public final Boolean acceptRoleSessionName() {
        return this.acceptRoleSessionName;
    }

    public final Integer durationSeconds() {
        return this.durationSeconds;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final boolean hasManagedPolicyArns() {
        return this.managedPolicyArns != null && !(this.managedPolicyArns instanceof SdkAutoConstructList);
    }

    public final List<String> managedPolicyArns() {
        return this.managedPolicyArns;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean requireInstanceProperties() {
        return this.requireInstanceProperties;
    }

    public final boolean hasRoleArns() {
        return this.roleArns != null && !(this.roleArns instanceof SdkAutoConstructList);
    }

    public final List<String> roleArns() {
        return this.roleArns;
    }

    public final String sessionPolicy() {
        return this.sessionPolicy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptRoleSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedPolicyArns() ? this.managedPolicyArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.requireInstanceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoleArns() ? this.roleArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileRequest)) {
            return false;
        }
        CreateProfileRequest other = (CreateProfileRequest)((Object)obj);
        return Objects.equals(this.acceptRoleSessionName(), other.acceptRoleSessionName()) && Objects.equals(this.durationSeconds(), other.durationSeconds()) && Objects.equals(this.enabled(), other.enabled()) && this.hasManagedPolicyArns() == other.hasManagedPolicyArns() && Objects.equals(this.managedPolicyArns(), other.managedPolicyArns()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.requireInstanceProperties(), other.requireInstanceProperties()) && this.hasRoleArns() == other.hasRoleArns() && Objects.equals(this.roleArns(), other.roleArns()) && Objects.equals(this.sessionPolicy(), other.sessionPolicy()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProfileRequest").add("AcceptRoleSessionName", (Object)this.acceptRoleSessionName()).add("DurationSeconds", (Object)this.durationSeconds()).add("Enabled", (Object)this.enabled()).add("ManagedPolicyArns", this.hasManagedPolicyArns() ? this.managedPolicyArns() : null).add("Name", (Object)this.name()).add("RequireInstanceProperties", (Object)this.requireInstanceProperties()).add("RoleArns", this.hasRoleArns() ? this.roleArns() : null).add("SessionPolicy", (Object)this.sessionPolicy()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "acceptRoleSessionName": {
                return Optional.ofNullable(clazz.cast(this.acceptRoleSessionName()));
            }
            case "durationSeconds": {
                return Optional.ofNullable(clazz.cast(this.durationSeconds()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "managedPolicyArns": {
                return Optional.ofNullable(clazz.cast(this.managedPolicyArns()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "requireInstanceProperties": {
                return Optional.ofNullable(clazz.cast(this.requireInstanceProperties()));
            }
            case "roleArns": {
                return Optional.ofNullable(clazz.cast(this.roleArns()));
            }
            case "sessionPolicy": {
                return Optional.ofNullable(clazz.cast(this.sessionPolicy()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("acceptRoleSessionName", ACCEPT_ROLE_SESSION_NAME_FIELD);
        map.put("durationSeconds", DURATION_SECONDS_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("managedPolicyArns", MANAGED_POLICY_ARNS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("requireInstanceProperties", REQUIRE_INSTANCE_PROPERTIES_FIELD);
        map.put("roleArns", ROLE_ARNS_FIELD);
        map.put("sessionPolicy", SESSION_POLICY_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProfileRequest, T> g) {
        return obj -> g.apply((CreateProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereRequest.BuilderImpl
    implements Builder {
        private Boolean acceptRoleSessionName;
        private Integer durationSeconds;
        private Boolean enabled;
        private List<String> managedPolicyArns = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Boolean requireInstanceProperties;
        private List<String> roleArns = DefaultSdkAutoConstructList.getInstance();
        private String sessionPolicy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileRequest model) {
            super(model);
            this.acceptRoleSessionName(model.acceptRoleSessionName);
            this.durationSeconds(model.durationSeconds);
            this.enabled(model.enabled);
            this.managedPolicyArns(model.managedPolicyArns);
            this.name(model.name);
            this.requireInstanceProperties(model.requireInstanceProperties);
            this.roleArns(model.roleArns);
            this.sessionPolicy(model.sessionPolicy);
            this.tags(model.tags);
        }

        public final Boolean getAcceptRoleSessionName() {
            return this.acceptRoleSessionName;
        }

        public final void setAcceptRoleSessionName(Boolean acceptRoleSessionName) {
            this.acceptRoleSessionName = acceptRoleSessionName;
        }

        @Override
        public final Builder acceptRoleSessionName(Boolean acceptRoleSessionName) {
            this.acceptRoleSessionName = acceptRoleSessionName;
            return this;
        }

        public final Integer getDurationSeconds() {
            return this.durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Collection<String> getManagedPolicyArns() {
            if (this.managedPolicyArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.managedPolicyArns;
        }

        public final void setManagedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
        }

        @Override
        public final Builder managedPolicyArns(Collection<String> managedPolicyArns) {
            this.managedPolicyArns = ManagedPolicyListCopier.copy(managedPolicyArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedPolicyArns(String ... managedPolicyArns) {
            this.managedPolicyArns(Arrays.asList(managedPolicyArns));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getRequireInstanceProperties() {
            return this.requireInstanceProperties;
        }

        public final void setRequireInstanceProperties(Boolean requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
        }

        @Override
        public final Builder requireInstanceProperties(Boolean requireInstanceProperties) {
            this.requireInstanceProperties = requireInstanceProperties;
            return this;
        }

        public final Collection<String> getRoleArns() {
            if (this.roleArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.roleArns;
        }

        public final void setRoleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
        }

        @Override
        public final Builder roleArns(Collection<String> roleArns) {
            this.roleArns = RoleArnListCopier.copy(roleArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleArns(String ... roleArns) {
            this.roleArns(Arrays.asList(roleArns));
            return this;
        }

        public final String getSessionPolicy() {
            return this.sessionPolicy;
        }

        public final void setSessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
        }

        @Override
        public final Builder sessionPolicy(String sessionPolicy) {
            this.sessionPolicy = sessionPolicy;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfileRequest build() {
            return new CreateProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RolesAnywhereRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProfileRequest> {
        public Builder acceptRoleSessionName(Boolean var1);

        public Builder durationSeconds(Integer var1);

        public Builder enabled(Boolean var1);

        public Builder managedPolicyArns(Collection<String> var1);

        public Builder managedPolicyArns(String ... var1);

        public Builder name(String var1);

        public Builder requireInstanceProperties(Boolean var1);

        public Builder roleArns(Collection<String> var1);

        public Builder roleArns(String ... var1);

        public Builder sessionPolicy(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

