/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationChannel;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationEvent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotificationSettingKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NotificationSettingKey> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channel").getter(NotificationSettingKey.getter(NotificationSettingKey::channelAsString)).setter(NotificationSettingKey.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<String> EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("event").getter(NotificationSettingKey.getter(NotificationSettingKey::eventAsString)).setter(NotificationSettingKey.setter(Builder::event)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, EVENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NotificationSettingKey.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channel;
    private final String event;

    private NotificationSettingKey(BuilderImpl builder) {
        this.channel = builder.channel;
        this.event = builder.event;
    }

    public final NotificationChannel channel() {
        return NotificationChannel.fromValue(this.channel);
    }

    public final String channelAsString() {
        return this.channel;
    }

    public final NotificationEvent event() {
        return NotificationEvent.fromValue(this.event);
    }

    public final String eventAsString() {
        return this.event;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationSettingKey)) {
            return false;
        }
        NotificationSettingKey other = (NotificationSettingKey)obj;
        return Objects.equals(this.channelAsString(), other.channelAsString()) && Objects.equals(this.eventAsString(), other.eventAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NotificationSettingKey").add("Channel", (Object)this.channelAsString()).add("Event", (Object)this.eventAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channelAsString()));
            }
            case "event": {
                return Optional.ofNullable(clazz.cast(this.eventAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("channel", CHANNEL_FIELD);
        map.put("event", EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationSettingKey, T> g) {
        return obj -> g.apply((NotificationSettingKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channel;
        private String event;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationSettingKey model) {
            this.channel(model.channel);
            this.event(model.event);
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        @Override
        public final Builder channel(NotificationChannel channel) {
            this.channel(channel == null ? null : channel.toString());
            return this;
        }

        public final String getEvent() {
            return this.event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(NotificationEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public NotificationSettingKey build() {
            return new NotificationSettingKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NotificationSettingKey> {
        public Builder channel(String var1);

        public Builder channel(NotificationChannel var1);

        public Builder event(String var1);

        public Builder event(NotificationEvent var1);
    }
}

