/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingKey;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingKeysCopier;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetNotificationSettingsRequest
extends RolesAnywhereRequest
implements ToCopyableBuilder<Builder, ResetNotificationSettingsRequest> {
    private static final SdkField<List<NotificationSettingKey>> NOTIFICATION_SETTING_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationSettingKeys").getter(ResetNotificationSettingsRequest.getter(ResetNotificationSettingsRequest::notificationSettingKeys)).setter(ResetNotificationSettingsRequest.setter(Builder::notificationSettingKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSettingKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationSettingKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TRUST_ANCHOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustAnchorId").getter(ResetNotificationSettingsRequest.getter(ResetNotificationSettingsRequest::trustAnchorId)).setter(ResetNotificationSettingsRequest.setter(Builder::trustAnchorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTIFICATION_SETTING_KEYS_FIELD, TRUST_ANCHOR_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("notificationSettingKeys", NOTIFICATION_SETTING_KEYS_FIELD);
            this.put("trustAnchorId", TRUST_ANCHOR_ID_FIELD);
        }
    });
    private final List<NotificationSettingKey> notificationSettingKeys;
    private final String trustAnchorId;

    private ResetNotificationSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.notificationSettingKeys = builder.notificationSettingKeys;
        this.trustAnchorId = builder.trustAnchorId;
    }

    public final boolean hasNotificationSettingKeys() {
        return this.notificationSettingKeys != null && !(this.notificationSettingKeys instanceof SdkAutoConstructList);
    }

    public final List<NotificationSettingKey> notificationSettingKeys() {
        return this.notificationSettingKeys;
    }

    public final String trustAnchorId() {
        return this.trustAnchorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationSettingKeys() ? this.notificationSettingKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchorId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetNotificationSettingsRequest)) {
            return false;
        }
        ResetNotificationSettingsRequest other = (ResetNotificationSettingsRequest)((Object)obj);
        return this.hasNotificationSettingKeys() == other.hasNotificationSettingKeys() && Objects.equals(this.notificationSettingKeys(), other.notificationSettingKeys()) && Objects.equals(this.trustAnchorId(), other.trustAnchorId());
    }

    public final String toString() {
        return ToString.builder((String)"ResetNotificationSettingsRequest").add("NotificationSettingKeys", this.hasNotificationSettingKeys() ? this.notificationSettingKeys() : null).add("TrustAnchorId", (Object)this.trustAnchorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "notificationSettingKeys": {
                return Optional.ofNullable(clazz.cast(this.notificationSettingKeys()));
            }
            case "trustAnchorId": {
                return Optional.ofNullable(clazz.cast(this.trustAnchorId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResetNotificationSettingsRequest, T> g) {
        return obj -> g.apply((ResetNotificationSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereRequest.BuilderImpl
    implements Builder {
        private List<NotificationSettingKey> notificationSettingKeys = DefaultSdkAutoConstructList.getInstance();
        private String trustAnchorId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetNotificationSettingsRequest model) {
            super(model);
            this.notificationSettingKeys(model.notificationSettingKeys);
            this.trustAnchorId(model.trustAnchorId);
        }

        public final List<NotificationSettingKey.Builder> getNotificationSettingKeys() {
            List<NotificationSettingKey.Builder> result = NotificationSettingKeysCopier.copyToBuilder(this.notificationSettingKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationSettingKeys(Collection<NotificationSettingKey.BuilderImpl> notificationSettingKeys) {
            this.notificationSettingKeys = NotificationSettingKeysCopier.copyFromBuilder(notificationSettingKeys);
        }

        @Override
        public final Builder notificationSettingKeys(Collection<NotificationSettingKey> notificationSettingKeys) {
            this.notificationSettingKeys = NotificationSettingKeysCopier.copy(notificationSettingKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettingKeys(NotificationSettingKey ... notificationSettingKeys) {
            this.notificationSettingKeys(Arrays.asList(notificationSettingKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettingKeys(Consumer<NotificationSettingKey.Builder> ... notificationSettingKeys) {
            this.notificationSettingKeys(Stream.of(notificationSettingKeys).map(c -> (NotificationSettingKey)((NotificationSettingKey.Builder)NotificationSettingKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrustAnchorId() {
            return this.trustAnchorId;
        }

        public final void setTrustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
        }

        @Override
        public final Builder trustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetNotificationSettingsRequest build() {
            return new ResetNotificationSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RolesAnywhereRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetNotificationSettingsRequest> {
        public Builder notificationSettingKeys(Collection<NotificationSettingKey> var1);

        public Builder notificationSettingKeys(NotificationSettingKey ... var1);

        public Builder notificationSettingKeys(Consumer<NotificationSettingKey.Builder> ... var1);

        public Builder trustAnchorId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

