/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rolesanywhere.model.InstancePropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceProperty> {
    private static final SdkField<Boolean> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("failed").getter(InstanceProperty.getter(InstanceProperty::failed)).setter(InstanceProperty.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(InstanceProperty.getter(InstanceProperty::properties)).setter(InstanceProperty.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> SEEN_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("seenAt").getter(InstanceProperty.getter(InstanceProperty::seenAt)).setter(InstanceProperty.setter(Builder::seenAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("seenAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD, PROPERTIES_FIELD, SEEN_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("failed", FAILED_FIELD);
            this.put("properties", PROPERTIES_FIELD);
            this.put("seenAt", SEEN_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean failed;
    private final Map<String, String> properties;
    private final Instant seenAt;

    private InstanceProperty(BuilderImpl builder) {
        this.failed = builder.failed;
        this.properties = builder.properties;
        this.seenAt = builder.seenAt;
    }

    public final Boolean failed() {
        return this.failed;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> properties() {
        return this.properties;
    }

    public final Instant seenAt() {
        return this.seenAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.seenAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceProperty)) {
            return false;
        }
        InstanceProperty other = (InstanceProperty)obj;
        return Objects.equals(this.failed(), other.failed()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.seenAt(), other.seenAt());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceProperty").add("Failed", (Object)this.failed()).add("Properties", this.hasProperties() ? this.properties() : null).add("SeenAt", (Object)this.seenAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "seenAt": {
                return Optional.ofNullable(clazz.cast(this.seenAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InstanceProperty, T> g) {
        return obj -> g.apply((InstanceProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean failed;
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();
        private Instant seenAt;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceProperty model) {
            this.failed(model.failed);
            this.properties(model.properties);
            this.seenAt(model.seenAt);
        }

        public final Boolean getFailed() {
            return this.failed;
        }

        public final void setFailed(Boolean failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Boolean failed) {
            this.failed = failed;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = InstancePropertyMapCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = InstancePropertyMapCopier.copy(properties);
            return this;
        }

        public final Instant getSeenAt() {
            return this.seenAt;
        }

        public final void setSeenAt(Instant seenAt) {
            this.seenAt = seenAt;
        }

        @Override
        public final Builder seenAt(Instant seenAt) {
            this.seenAt = seenAt;
            return this;
        }

        public InstanceProperty build() {
            return new InstanceProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceProperty> {
        public Builder failed(Boolean var1);

        public Builder properties(Map<String, String> var1);

        public Builder seenAt(Instant var1);
    }
}

