/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.CertificateField;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereRequest;
import software.amazon.awssdk.services.rolesanywhere.model.SpecifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAttributeMappingRequest
extends RolesAnywhereRequest
implements ToCopyableBuilder<Builder, DeleteAttributeMappingRequest> {
    private static final SdkField<String> CERTIFICATE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateField").getter(DeleteAttributeMappingRequest.getter(DeleteAttributeMappingRequest::certificateFieldAsString)).setter(DeleteAttributeMappingRequest.setter(Builder::certificateField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("certificateField").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("profileId").getter(DeleteAttributeMappingRequest.getter(DeleteAttributeMappingRequest::profileId)).setter(DeleteAttributeMappingRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("profileId").build()}).build();
    private static final SdkField<List<String>> SPECIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("specifiers").getter(DeleteAttributeMappingRequest.getter(DeleteAttributeMappingRequest::specifiers)).setter(DeleteAttributeMappingRequest.setter(Builder::specifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("specifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD_FIELD, PROFILE_ID_FIELD, SPECIFIERS_FIELD));
    private final String certificateField;
    private final String profileId;
    private final List<String> specifiers;

    private DeleteAttributeMappingRequest(BuilderImpl builder) {
        super(builder);
        this.certificateField = builder.certificateField;
        this.profileId = builder.profileId;
        this.specifiers = builder.specifiers;
    }

    public final CertificateField certificateField() {
        return CertificateField.fromValue(this.certificateField);
    }

    public final String certificateFieldAsString() {
        return this.certificateField;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final boolean hasSpecifiers() {
        return this.specifiers != null && !(this.specifiers instanceof SdkAutoConstructList);
    }

    public final List<String> specifiers() {
        return this.specifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateFieldAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpecifiers() ? this.specifiers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAttributeMappingRequest)) {
            return false;
        }
        DeleteAttributeMappingRequest other = (DeleteAttributeMappingRequest)((Object)obj);
        return Objects.equals(this.certificateFieldAsString(), other.certificateFieldAsString()) && Objects.equals(this.profileId(), other.profileId()) && this.hasSpecifiers() == other.hasSpecifiers() && Objects.equals(this.specifiers(), other.specifiers());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAttributeMappingRequest").add("CertificateField", (Object)this.certificateFieldAsString()).add("ProfileId", (Object)this.profileId()).add("Specifiers", this.hasSpecifiers() ? this.specifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateField": {
                return Optional.ofNullable(clazz.cast(this.certificateFieldAsString()));
            }
            case "profileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "specifiers": {
                return Optional.ofNullable(clazz.cast(this.specifiers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAttributeMappingRequest, T> g) {
        return obj -> g.apply((DeleteAttributeMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereRequest.BuilderImpl
    implements Builder {
        private String certificateField;
        private String profileId;
        private List<String> specifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAttributeMappingRequest model) {
            super(model);
            this.certificateField(model.certificateField);
            this.profileId(model.profileId);
            this.specifiers(model.specifiers);
        }

        public final String getCertificateField() {
            return this.certificateField;
        }

        public final void setCertificateField(String certificateField) {
            this.certificateField = certificateField;
        }

        @Override
        public final Builder certificateField(String certificateField) {
            this.certificateField = certificateField;
            return this;
        }

        @Override
        public final Builder certificateField(CertificateField certificateField) {
            this.certificateField(certificateField == null ? null : certificateField.toString());
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final Collection<String> getSpecifiers() {
            if (this.specifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.specifiers;
        }

        public final void setSpecifiers(Collection<String> specifiers) {
            this.specifiers = SpecifierListCopier.copy(specifiers);
        }

        @Override
        public final Builder specifiers(Collection<String> specifiers) {
            this.specifiers = SpecifierListCopier.copy(specifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder specifiers(String ... specifiers) {
            this.specifiers(Arrays.asList(specifiers));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAttributeMappingRequest build() {
            return new DeleteAttributeMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RolesAnywhereRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAttributeMappingRequest> {
        public Builder certificateField(String var1);

        public Builder certificateField(CertificateField var1);

        public Builder profileId(String var1);

        public Builder specifiers(Collection<String> var1);

        public Builder specifiers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

