/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.rolesanywhere.DefaultRolesAnywhereBaseClientBuilder;
import software.amazon.awssdk.services.rolesanywhere.DefaultRolesAnywhereClient;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereClient;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereClientBuilder;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereServiceClientConfiguration;
import software.amazon.awssdk.services.rolesanywhere.endpoints.RolesAnywhereEndpointProvider;

@SdkInternalApi
final class DefaultRolesAnywhereClientBuilder
extends DefaultRolesAnywhereBaseClientBuilder<RolesAnywhereClientBuilder, RolesAnywhereClient>
implements RolesAnywhereClientBuilder {
    DefaultRolesAnywhereClientBuilder() {
    }

    @Override
    public DefaultRolesAnywhereClientBuilder endpointProvider(RolesAnywhereEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RolesAnywhereClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultRolesAnywhereClientBuilder.validateClientOptions(clientConfiguration);
        RolesAnywhereServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultRolesAnywhereClient client = new DefaultRolesAnywhereClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private RolesAnywhereServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return RolesAnywhereServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

