/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereClient;
import software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListTrustAnchorsResponse;
import software.amazon.awssdk.services.rolesanywhere.model.TrustAnchorDetail;

public class ListTrustAnchorsIterable
implements SdkIterable<ListTrustAnchorsResponse> {
    private final RolesAnywhereClient client;
    private final ListTrustAnchorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrustAnchorsIterable(RolesAnywhereClient client, ListTrustAnchorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTrustAnchorsResponseFetcher();
    }

    public Iterator<ListTrustAnchorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrustAnchorDetail> trustAnchors() {
        Function<ListTrustAnchorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trustAnchors() != null) {
                return response.trustAnchors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrustAnchorsResponseFetcher
    implements SyncPageFetcher<ListTrustAnchorsResponse> {
        private ListTrustAnchorsResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustAnchorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrustAnchorsResponse nextPage(ListTrustAnchorsResponse previousPage) {
            if (previousPage == null) {
                return ListTrustAnchorsIterable.this.client.listTrustAnchors(ListTrustAnchorsIterable.this.firstRequest);
            }
            return ListTrustAnchorsIterable.this.client.listTrustAnchors((ListTrustAnchorsRequest)((Object)ListTrustAnchorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

