/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rolesanywhere.RolesAnywhereClient;
import software.amazon.awssdk.services.rolesanywhere.internal.UserAgentUtils;
import software.amazon.awssdk.services.rolesanywhere.model.CrlDetail;
import software.amazon.awssdk.services.rolesanywhere.model.ListCrlsRequest;
import software.amazon.awssdk.services.rolesanywhere.model.ListCrlsResponse;

public class ListCrlsIterable
implements SdkIterable<ListCrlsResponse> {
    private final RolesAnywhereClient client;
    private final ListCrlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCrlsIterable(RolesAnywhereClient client, ListCrlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCrlsResponseFetcher();
    }

    public Iterator<ListCrlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CrlDetail> crls() {
        Function<ListCrlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.crls() != null) {
                return response.crls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCrlsResponseFetcher
    implements SyncPageFetcher<ListCrlsResponse> {
        private ListCrlsResponseFetcher() {
        }

        public boolean hasNextPage(ListCrlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCrlsResponse nextPage(ListCrlsResponse previousPage) {
            if (previousPage == null) {
                return ListCrlsIterable.this.client.listCrls(ListCrlsIterable.this.firstRequest);
            }
            return ListCrlsIterable.this.client.listCrls((ListCrlsRequest)((Object)ListCrlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

