/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.EnvironmentVariableMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchConfig> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchConfig.getter(LaunchConfig::packageName)).setter(LaunchConfig.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()}).build();
    private static final SdkField<String> LAUNCH_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchConfig.getter(LaunchConfig::launchFile)).setter(LaunchConfig.setter(Builder::launchFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchFile").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(LaunchConfig.getter(LaunchConfig::environmentVariables)).setter(LaunchConfig.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, LAUNCH_FILE_FIELD, ENVIRONMENT_VARIABLES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String packageName;
    private final String launchFile;
    private final Map<String, String> environmentVariables;

    private LaunchConfig(BuilderImpl builder) {
        this.packageName = builder.packageName;
        this.launchFile = builder.launchFile;
        this.environmentVariables = builder.environmentVariables;
    }

    public String packageName() {
        return this.packageName;
    }

    public String launchFile() {
        return this.launchFile;
    }

    public Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentVariables());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfig)) {
            return false;
        }
        LaunchConfig other = (LaunchConfig)obj;
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.launchFile(), other.launchFile()) && Objects.equals(this.environmentVariables(), other.environmentVariables());
    }

    public String toString() {
        return ToString.builder((String)"LaunchConfig").add("PackageName", (Object)this.packageName()).add("LaunchFile", (Object)this.launchFile()).add("EnvironmentVariables", this.environmentVariables()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "launchFile": {
                return Optional.ofNullable(clazz.cast(this.launchFile()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchConfig, T> g) {
        return obj -> g.apply((LaunchConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String packageName;
        private String launchFile;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfig model) {
            this.packageName(model.packageName);
            this.launchFile(model.launchFile);
            this.environmentVariables(model.environmentVariables);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public final String getLaunchFile() {
            return this.launchFile;
        }

        @Override
        public final Builder launchFile(String launchFile) {
            this.launchFile = launchFile;
            return this;
        }

        public final void setLaunchFile(String launchFile) {
            this.launchFile = launchFile;
        }

        public final Map<String, String> getEnvironmentVariables() {
            return this.environmentVariables;
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
            return this;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariableMapCopier.copy(environmentVariables);
        }

        public LaunchConfig build() {
            return new LaunchConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchConfig> {
        public Builder packageName(String var1);

        public Builder launchFile(String var1);

        public Builder environmentVariables(Map<String, String> var1);
    }
}

