/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RobotApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RobotApplicationSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RobotApplicationSummary.getter(RobotApplicationSummary::name)).setter(RobotApplicationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RobotApplicationSummary.getter(RobotApplicationSummary::arn)).setter(RobotApplicationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RobotApplicationSummary.getter(RobotApplicationSummary::version)).setter(RobotApplicationSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RobotApplicationSummary.getter(RobotApplicationSummary::lastUpdatedAt)).setter(RobotApplicationSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, VERSION_FIELD, LAST_UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String version;
    private final Instant lastUpdatedAt;

    private RobotApplicationSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.version = builder.version;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String version() {
        return this.version;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RobotApplicationSummary)) {
            return false;
        }
        RobotApplicationSummary other = (RobotApplicationSummary)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public String toString() {
        return ToString.builder((String)"RobotApplicationSummary").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Version", (Object)this.version()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RobotApplicationSummary, T> g) {
        return obj -> g.apply((RobotApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String version;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(RobotApplicationSummary model) {
            this.name(model.name);
            this.arn(model.arn);
            this.version(model.version);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public RobotApplicationSummary build() {
            return new RobotApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RobotApplicationSummary> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder version(String var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

