/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.FailureBehavior;
import software.amazon.awssdk.services.robomaker.model.OutputLocation;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.RobotApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfig;
import software.amazon.awssdk.services.robomaker.model.SimulationApplicationConfigsCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationJobErrorCode;
import software.amazon.awssdk.services.robomaker.model.SimulationJobStatus;
import software.amazon.awssdk.services.robomaker.model.VPCConfigResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimulationJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimulationJob> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJob.getter(SimulationJob::arn)).setter(SimulationJob.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJob.getter(SimulationJob::name)).setter(SimulationJob.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJob.getter(SimulationJob::statusAsString)).setter(SimulationJob.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(SimulationJob.getter(SimulationJob::lastUpdatedAt)).setter(SimulationJob.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> FAILURE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJob.getter(SimulationJob::failureBehaviorAsString)).setter(SimulationJob.setter(Builder::failureBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureBehavior").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJob.getter(SimulationJob::failureCodeAsString)).setter(SimulationJob.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJob.getter(SimulationJob::clientRequestToken)).setter(SimulationJob.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SimulationJob.getter(SimulationJob::outputLocation)).setter(SimulationJob.setter(Builder::outputLocation)).constructor(OutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final SdkField<Long> MAX_JOB_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(SimulationJob.getter(SimulationJob::maxJobDurationInSeconds)).setter(SimulationJob.setter(Builder::maxJobDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobDurationInSeconds").build()}).build();
    private static final SdkField<Long> SIMULATION_TIME_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(SimulationJob.getter(SimulationJob::simulationTimeMillis)).setter(SimulationJob.setter(Builder::simulationTimeMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationTimeMillis").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SimulationJob.getter(SimulationJob::iamRole)).setter(SimulationJob.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()}).build();
    private static final SdkField<List<RobotApplicationConfig>> ROBOT_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulationJob.getter(SimulationJob::robotApplications)).setter(SimulationJob.setter(Builder::robotApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RobotApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SimulationApplicationConfig>> SIMULATION_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(SimulationJob.getter(SimulationJob::simulationApplications)).setter(SimulationJob.setter(Builder::simulationApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationApplicationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VPCConfigResponse> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SimulationJob.getter(SimulationJob::vpcConfig)).setter(SimulationJob.setter(Builder::vpcConfig)).constructor(VPCConfigResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, STATUS_FIELD, LAST_UPDATED_AT_FIELD, FAILURE_BEHAVIOR_FIELD, FAILURE_CODE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, OUTPUT_LOCATION_FIELD, MAX_JOB_DURATION_IN_SECONDS_FIELD, SIMULATION_TIME_MILLIS_FIELD, IAM_ROLE_FIELD, ROBOT_APPLICATIONS_FIELD, SIMULATION_APPLICATIONS_FIELD, VPC_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String status;
    private final Instant lastUpdatedAt;
    private final String failureBehavior;
    private final String failureCode;
    private final String clientRequestToken;
    private final OutputLocation outputLocation;
    private final Long maxJobDurationInSeconds;
    private final Long simulationTimeMillis;
    private final String iamRole;
    private final List<RobotApplicationConfig> robotApplications;
    private final List<SimulationApplicationConfig> simulationApplications;
    private final VPCConfigResponse vpcConfig;

    private SimulationJob(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.failureBehavior = builder.failureBehavior;
        this.failureCode = builder.failureCode;
        this.clientRequestToken = builder.clientRequestToken;
        this.outputLocation = builder.outputLocation;
        this.maxJobDurationInSeconds = builder.maxJobDurationInSeconds;
        this.simulationTimeMillis = builder.simulationTimeMillis;
        this.iamRole = builder.iamRole;
        this.robotApplications = builder.robotApplications;
        this.simulationApplications = builder.simulationApplications;
        this.vpcConfig = builder.vpcConfig;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public SimulationJobStatus status() {
        return SimulationJobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public FailureBehavior failureBehavior() {
        return FailureBehavior.fromValue(this.failureBehavior);
    }

    public String failureBehaviorAsString() {
        return this.failureBehavior;
    }

    public SimulationJobErrorCode failureCode() {
        return SimulationJobErrorCode.fromValue(this.failureCode);
    }

    public String failureCodeAsString() {
        return this.failureCode;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public OutputLocation outputLocation() {
        return this.outputLocation;
    }

    public Long maxJobDurationInSeconds() {
        return this.maxJobDurationInSeconds;
    }

    public Long simulationTimeMillis() {
        return this.simulationTimeMillis;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public List<RobotApplicationConfig> robotApplications() {
        return this.robotApplications;
    }

    public List<SimulationApplicationConfig> simulationApplications() {
        return this.simulationApplications;
    }

    public VPCConfigResponse vpcConfig() {
        return this.vpcConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxJobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulationTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.robotApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.simulationApplications());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationJob)) {
            return false;
        }
        SimulationJob other = (SimulationJob)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.failureBehaviorAsString(), other.failureBehaviorAsString()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.maxJobDurationInSeconds(), other.maxJobDurationInSeconds()) && Objects.equals(this.simulationTimeMillis(), other.simulationTimeMillis()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.robotApplications(), other.robotApplications()) && Objects.equals(this.simulationApplications(), other.simulationApplications()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public String toString() {
        return ToString.builder((String)"SimulationJob").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("FailureBehavior", (Object)this.failureBehaviorAsString()).add("FailureCode", (Object)this.failureCodeAsString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("OutputLocation", (Object)this.outputLocation()).add("MaxJobDurationInSeconds", (Object)this.maxJobDurationInSeconds()).add("SimulationTimeMillis", (Object)this.simulationTimeMillis()).add("IamRole", (Object)this.iamRole()).add("RobotApplications", this.robotApplications()).add("SimulationApplications", this.simulationApplications()).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "failureBehavior": {
                return Optional.ofNullable(clazz.cast(this.failureBehaviorAsString()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "maxJobDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxJobDurationInSeconds()));
            }
            case "simulationTimeMillis": {
                return Optional.ofNullable(clazz.cast(this.simulationTimeMillis()));
            }
            case "iamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "robotApplications": {
                return Optional.ofNullable(clazz.cast(this.robotApplications()));
            }
            case "simulationApplications": {
                return Optional.ofNullable(clazz.cast(this.simulationApplications()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationJob, T> g) {
        return obj -> g.apply((SimulationJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String status;
        private Instant lastUpdatedAt;
        private String failureBehavior;
        private String failureCode;
        private String clientRequestToken;
        private OutputLocation outputLocation;
        private Long maxJobDurationInSeconds;
        private Long simulationTimeMillis;
        private String iamRole;
        private List<RobotApplicationConfig> robotApplications = DefaultSdkAutoConstructList.getInstance();
        private List<SimulationApplicationConfig> simulationApplications = DefaultSdkAutoConstructList.getInstance();
        private VPCConfigResponse vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationJob model) {
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.failureBehavior(model.failureBehavior);
            this.failureCode(model.failureCode);
            this.clientRequestToken(model.clientRequestToken);
            this.outputLocation(model.outputLocation);
            this.maxJobDurationInSeconds(model.maxJobDurationInSeconds);
            this.simulationTimeMillis(model.simulationTimeMillis);
            this.iamRole(model.iamRole);
            this.robotApplications(model.robotApplications);
            this.simulationApplications(model.simulationApplications);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationJobStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getFailureBehaviorAsString() {
            return this.failureBehavior;
        }

        @Override
        public final Builder failureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
            return this;
        }

        @Override
        public final Builder failureBehavior(FailureBehavior failureBehavior) {
            this.failureBehavior(failureBehavior.toString());
            return this;
        }

        public final void setFailureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
        }

        public final String getFailureCodeAsString() {
            return this.failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(SimulationJobErrorCode failureCode) {
            this.failureCode(failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final Long getMaxJobDurationInSeconds() {
            return this.maxJobDurationInSeconds;
        }

        @Override
        public final Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
            return this;
        }

        public final void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
        }

        public final Long getSimulationTimeMillis() {
            return this.simulationTimeMillis;
        }

        @Override
        public final Builder simulationTimeMillis(Long simulationTimeMillis) {
            this.simulationTimeMillis = simulationTimeMillis;
            return this;
        }

        public final void setSimulationTimeMillis(Long simulationTimeMillis) {
            this.simulationTimeMillis = simulationTimeMillis;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Collection<RobotApplicationConfig.Builder> getRobotApplications() {
            return this.robotApplications != null ? (Collection)this.robotApplications.stream().map(RobotApplicationConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder robotApplications(Collection<RobotApplicationConfig> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copy(robotApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(RobotApplicationConfig ... robotApplications) {
            this.robotApplications(Arrays.asList(robotApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... robotApplications) {
            this.robotApplications(Stream.of(robotApplications).map(c -> (RobotApplicationConfig)((RobotApplicationConfig.Builder)RobotApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRobotApplications(Collection<RobotApplicationConfig.BuilderImpl> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copyFromBuilder(robotApplications);
        }

        public final Collection<SimulationApplicationConfig.Builder> getSimulationApplications() {
            return this.simulationApplications != null ? (Collection)this.simulationApplications.stream().map(SimulationApplicationConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copy(simulationApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(SimulationApplicationConfig ... simulationApplications) {
            this.simulationApplications(Arrays.asList(simulationApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... simulationApplications) {
            this.simulationApplications(Stream.of(simulationApplications).map(c -> (SimulationApplicationConfig)((SimulationApplicationConfig.Builder)SimulationApplicationConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSimulationApplications(Collection<SimulationApplicationConfig.BuilderImpl> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copyFromBuilder(simulationApplications);
        }

        public final VPCConfigResponse.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VPCConfigResponse vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VPCConfigResponse.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public SimulationJob build() {
            return new SimulationJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimulationJob> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(SimulationJobStatus var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder failureBehavior(String var1);

        public Builder failureBehavior(FailureBehavior var1);

        public Builder failureCode(String var1);

        public Builder failureCode(SimulationJobErrorCode var1);

        public Builder clientRequestToken(String var1);

        public Builder outputLocation(OutputLocation var1);

        default public Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return this.outputLocation((OutputLocation)((OutputLocation.Builder)OutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder maxJobDurationInSeconds(Long var1);

        public Builder simulationTimeMillis(Long var1);

        public Builder iamRole(String var1);

        public Builder robotApplications(Collection<RobotApplicationConfig> var1);

        public Builder robotApplications(RobotApplicationConfig ... var1);

        public Builder robotApplications(Consumer<RobotApplicationConfig.Builder> ... var1);

        public Builder simulationApplications(Collection<SimulationApplicationConfig> var1);

        public Builder simulationApplications(SimulationApplicationConfig ... var1);

        public Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder> ... var1);

        public Builder vpcConfig(VPCConfigResponse var1);

        default public Builder vpcConfig(Consumer<VPCConfigResponse.Builder> vpcConfig) {
            return this.vpcConfig((VPCConfigResponse)((VPCConfigResponse.Builder)VPCConfigResponse.builder().applyMutation(vpcConfig)).build());
        }
    }
}

