/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.BatchPolicy;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequestsCopier;
import software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.FailedCreateSimulationJobRequestsCopier;
import software.amazon.awssdk.services.robomaker.model.RoboMakerResponse;
import software.amazon.awssdk.services.robomaker.model.SimulationJobBatchErrorCode;
import software.amazon.awssdk.services.robomaker.model.SimulationJobBatchStatus;
import software.amazon.awssdk.services.robomaker.model.SimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.SimulationJobSummariesCopier;
import software.amazon.awssdk.services.robomaker.model.SimulationJobSummary;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSimulationJobBatchResponse
extends RoboMakerResponse
implements ToCopyableBuilder<Builder, StartSimulationJobBatchResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::arn)).setter(StartSimulationJobBatchResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::statusAsString)).setter(StartSimulationJobBatchResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::createdAt)).setter(StartSimulationJobBatchResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::clientRequestToken)).setter(StartSimulationJobBatchResponse.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<BatchPolicy> BATCH_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("batchPolicy").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::batchPolicy)).setter(StartSimulationJobBatchResponse.setter(Builder::batchPolicy)).constructor(BatchPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchPolicy").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::failureCodeAsString)).setter(StartSimulationJobBatchResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::failureReason)).setter(StartSimulationJobBatchResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<List<FailedCreateSimulationJobRequest>> FAILED_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedRequests").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::failedRequests)).setter(StartSimulationJobBatchResponse.setter(Builder::failedRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedCreateSimulationJobRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SimulationJobRequest>> PENDING_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pendingRequests").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::pendingRequests)).setter(StartSimulationJobBatchResponse.setter(Builder::pendingRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationJobRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SimulationJobSummary>> CREATED_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("createdRequests").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::createdRequests)).setter(StartSimulationJobBatchResponse.setter(Builder::createdRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SimulationJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartSimulationJobBatchResponse.getter(StartSimulationJobBatchResponse::tags)).setter(StartSimulationJobBatchResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, CLIENT_REQUEST_TOKEN_FIELD, BATCH_POLICY_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD, FAILED_REQUESTS_FIELD, PENDING_REQUESTS_FIELD, CREATED_REQUESTS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("batchPolicy", BATCH_POLICY_FIELD);
            this.put("failureCode", FAILURE_CODE_FIELD);
            this.put("failureReason", FAILURE_REASON_FIELD);
            this.put("failedRequests", FAILED_REQUESTS_FIELD);
            this.put("pendingRequests", PENDING_REQUESTS_FIELD);
            this.put("createdRequests", CREATED_REQUESTS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String arn;
    private final String status;
    private final Instant createdAt;
    private final String clientRequestToken;
    private final BatchPolicy batchPolicy;
    private final String failureCode;
    private final String failureReason;
    private final List<FailedCreateSimulationJobRequest> failedRequests;
    private final List<SimulationJobRequest> pendingRequests;
    private final List<SimulationJobSummary> createdRequests;
    private final Map<String, String> tags;

    private StartSimulationJobBatchResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.clientRequestToken = builder.clientRequestToken;
        this.batchPolicy = builder.batchPolicy;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
        this.failedRequests = builder.failedRequests;
        this.pendingRequests = builder.pendingRequests;
        this.createdRequests = builder.createdRequests;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final SimulationJobBatchStatus status() {
        return SimulationJobBatchStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final BatchPolicy batchPolicy() {
        return this.batchPolicy;
    }

    public final SimulationJobBatchErrorCode failureCode() {
        return SimulationJobBatchErrorCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final boolean hasFailedRequests() {
        return this.failedRequests != null && !(this.failedRequests instanceof SdkAutoConstructList);
    }

    public final List<FailedCreateSimulationJobRequest> failedRequests() {
        return this.failedRequests;
    }

    public final boolean hasPendingRequests() {
        return this.pendingRequests != null && !(this.pendingRequests instanceof SdkAutoConstructList);
    }

    public final List<SimulationJobRequest> pendingRequests() {
        return this.pendingRequests;
    }

    public final boolean hasCreatedRequests() {
        return this.createdRequests != null && !(this.createdRequests instanceof SdkAutoConstructList);
    }

    public final List<SimulationJobSummary> createdRequests() {
        return this.createdRequests;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedRequests() ? this.failedRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingRequests() ? this.pendingRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreatedRequests() ? this.createdRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSimulationJobBatchResponse)) {
            return false;
        }
        StartSimulationJobBatchResponse other = (StartSimulationJobBatchResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.batchPolicy(), other.batchPolicy()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && this.hasFailedRequests() == other.hasFailedRequests() && Objects.equals(this.failedRequests(), other.failedRequests()) && this.hasPendingRequests() == other.hasPendingRequests() && Objects.equals(this.pendingRequests(), other.pendingRequests()) && this.hasCreatedRequests() == other.hasCreatedRequests() && Objects.equals(this.createdRequests(), other.createdRequests()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartSimulationJobBatchResponse").add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("BatchPolicy", (Object)this.batchPolicy()).add("FailureCode", (Object)this.failureCodeAsString()).add("FailureReason", (Object)this.failureReason()).add("FailedRequests", this.hasFailedRequests() ? this.failedRequests() : null).add("PendingRequests", this.hasPendingRequests() ? this.pendingRequests() : null).add("CreatedRequests", this.hasCreatedRequests() ? this.createdRequests() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "batchPolicy": {
                return Optional.ofNullable(clazz.cast(this.batchPolicy()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "failedRequests": {
                return Optional.ofNullable(clazz.cast(this.failedRequests()));
            }
            case "pendingRequests": {
                return Optional.ofNullable(clazz.cast(this.pendingRequests()));
            }
            case "createdRequests": {
                return Optional.ofNullable(clazz.cast(this.createdRequests()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartSimulationJobBatchResponse, T> g) {
        return obj -> g.apply((StartSimulationJobBatchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String status;
        private Instant createdAt;
        private String clientRequestToken;
        private BatchPolicy batchPolicy;
        private String failureCode;
        private String failureReason;
        private List<FailedCreateSimulationJobRequest> failedRequests = DefaultSdkAutoConstructList.getInstance();
        private List<SimulationJobRequest> pendingRequests = DefaultSdkAutoConstructList.getInstance();
        private List<SimulationJobSummary> createdRequests = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSimulationJobBatchResponse model) {
            super(model);
            this.arn(model.arn);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.clientRequestToken(model.clientRequestToken);
            this.batchPolicy(model.batchPolicy);
            this.failureCode(model.failureCode);
            this.failureReason(model.failureReason);
            this.failedRequests(model.failedRequests);
            this.pendingRequests(model.pendingRequests);
            this.createdRequests(model.createdRequests);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationJobBatchStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final BatchPolicy.Builder getBatchPolicy() {
            return this.batchPolicy != null ? this.batchPolicy.toBuilder() : null;
        }

        public final void setBatchPolicy(BatchPolicy.BuilderImpl batchPolicy) {
            this.batchPolicy = batchPolicy != null ? batchPolicy.build() : null;
        }

        @Override
        public final Builder batchPolicy(BatchPolicy batchPolicy) {
            this.batchPolicy = batchPolicy;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(SimulationJobBatchErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final List<FailedCreateSimulationJobRequest.Builder> getFailedRequests() {
            List<FailedCreateSimulationJobRequest.Builder> result = FailedCreateSimulationJobRequestsCopier.copyToBuilder(this.failedRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedRequests(Collection<FailedCreateSimulationJobRequest.BuilderImpl> failedRequests) {
            this.failedRequests = FailedCreateSimulationJobRequestsCopier.copyFromBuilder(failedRequests);
        }

        @Override
        public final Builder failedRequests(Collection<FailedCreateSimulationJobRequest> failedRequests) {
            this.failedRequests = FailedCreateSimulationJobRequestsCopier.copy(failedRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(FailedCreateSimulationJobRequest ... failedRequests) {
            this.failedRequests(Arrays.asList(failedRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(Consumer<FailedCreateSimulationJobRequest.Builder> ... failedRequests) {
            this.failedRequests(Stream.of(failedRequests).map(c -> (FailedCreateSimulationJobRequest)((FailedCreateSimulationJobRequest.Builder)FailedCreateSimulationJobRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SimulationJobRequest.Builder> getPendingRequests() {
            List<SimulationJobRequest.Builder> result = CreateSimulationJobRequestsCopier.copyToBuilder(this.pendingRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPendingRequests(Collection<SimulationJobRequest.BuilderImpl> pendingRequests) {
            this.pendingRequests = CreateSimulationJobRequestsCopier.copyFromBuilder(pendingRequests);
        }

        @Override
        public final Builder pendingRequests(Collection<SimulationJobRequest> pendingRequests) {
            this.pendingRequests = CreateSimulationJobRequestsCopier.copy(pendingRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingRequests(SimulationJobRequest ... pendingRequests) {
            this.pendingRequests(Arrays.asList(pendingRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingRequests(Consumer<SimulationJobRequest.Builder> ... pendingRequests) {
            this.pendingRequests(Stream.of(pendingRequests).map(c -> (SimulationJobRequest)((SimulationJobRequest.Builder)SimulationJobRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SimulationJobSummary.Builder> getCreatedRequests() {
            List<SimulationJobSummary.Builder> result = SimulationJobSummariesCopier.copyToBuilder(this.createdRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreatedRequests(Collection<SimulationJobSummary.BuilderImpl> createdRequests) {
            this.createdRequests = SimulationJobSummariesCopier.copyFromBuilder(createdRequests);
        }

        @Override
        public final Builder createdRequests(Collection<SimulationJobSummary> createdRequests) {
            this.createdRequests = SimulationJobSummariesCopier.copy(createdRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdRequests(SimulationJobSummary ... createdRequests) {
            this.createdRequests(Arrays.asList(createdRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdRequests(Consumer<SimulationJobSummary.Builder> ... createdRequests) {
            this.createdRequests(Stream.of(createdRequests).map(c -> (SimulationJobSummary)((SimulationJobSummary.Builder)SimulationJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public StartSimulationJobBatchResponse build() {
            return new StartSimulationJobBatchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RoboMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSimulationJobBatchResponse> {
        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(SimulationJobBatchStatus var1);

        public Builder createdAt(Instant var1);

        public Builder clientRequestToken(String var1);

        public Builder batchPolicy(BatchPolicy var1);

        default public Builder batchPolicy(Consumer<BatchPolicy.Builder> batchPolicy) {
            return this.batchPolicy((BatchPolicy)((BatchPolicy.Builder)BatchPolicy.builder().applyMutation(batchPolicy)).build());
        }

        public Builder failureCode(String var1);

        public Builder failureCode(SimulationJobBatchErrorCode var1);

        public Builder failureReason(String var1);

        public Builder failedRequests(Collection<FailedCreateSimulationJobRequest> var1);

        public Builder failedRequests(FailedCreateSimulationJobRequest ... var1);

        public Builder failedRequests(Consumer<FailedCreateSimulationJobRequest.Builder> ... var1);

        public Builder pendingRequests(Collection<SimulationJobRequest> var1);

        public Builder pendingRequests(SimulationJobRequest ... var1);

        public Builder pendingRequests(Consumer<SimulationJobRequest.Builder> ... var1);

        public Builder createdRequests(Collection<SimulationJobSummary> var1);

        public Builder createdRequests(SimulationJobSummary ... var1);

        public Builder createdRequests(Consumer<SimulationJobSummary.Builder> ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

