/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse;
import software.amazon.awssdk.services.robomaker.model.SimulationJobBatchSummary;

public class ListSimulationJobBatchesIterable
implements SdkIterable<ListSimulationJobBatchesResponse> {
    private final RoboMakerClient client;
    private final ListSimulationJobBatchesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSimulationJobBatchesIterable(RoboMakerClient client, ListSimulationJobBatchesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSimulationJobBatchesResponseFetcher();
    }

    public Iterator<ListSimulationJobBatchesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SimulationJobBatchSummary> simulationJobBatchSummaries() {
        Function<ListSimulationJobBatchesResponse, Iterator> getIterator = response -> {
            if (response != null && response.simulationJobBatchSummaries() != null) {
                return response.simulationJobBatchSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSimulationJobBatchesResponseFetcher
    implements SyncPageFetcher<ListSimulationJobBatchesResponse> {
        private ListSimulationJobBatchesResponseFetcher() {
        }

        public boolean hasNextPage(ListSimulationJobBatchesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSimulationJobBatchesResponse nextPage(ListSimulationJobBatchesResponse previousPage) {
            if (previousPage == null) {
                return ListSimulationJobBatchesIterable.this.client.listSimulationJobBatches(ListSimulationJobBatchesIterable.this.firstRequest);
            }
            return ListSimulationJobBatchesIterable.this.client.listSimulationJobBatches((ListSimulationJobBatchesRequest)((Object)ListSimulationJobBatchesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

