/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.S3KeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DataSourceConfig.getter(DataSourceConfig::name)).setter(DataSourceConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Bucket").getter(DataSourceConfig.getter(DataSourceConfig::s3Bucket)).setter(DataSourceConfig.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<List<String>> S3_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("s3Keys").getter(DataSourceConfig.getter(DataSourceConfig::s3Keys)).setter(DataSourceConfig.setter(Builder::s3Keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, S3_BUCKET_FIELD, S3_KEYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String s3Bucket;
    private final List<String> s3Keys;

    private DataSourceConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.s3Bucket = builder.s3Bucket;
        this.s3Keys = builder.s3Keys;
    }

    public final String name() {
        return this.name;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final boolean hasS3Keys() {
        return this.s3Keys != null && !(this.s3Keys instanceof SdkAutoConstructList);
    }

    public final List<String> s3Keys() {
        return this.s3Keys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasS3Keys() ? this.s3Keys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfig)) {
            return false;
        }
        DataSourceConfig other = (DataSourceConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && this.hasS3Keys() == other.hasS3Keys() && Objects.equals(this.s3Keys(), other.s3Keys());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceConfig").add("Name", (Object)this.name()).add("S3Bucket", (Object)this.s3Bucket()).add("S3Keys", this.hasS3Keys() ? this.s3Keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "s3Keys": {
                return Optional.ofNullable(clazz.cast(this.s3Keys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfig, T> g) {
        return obj -> g.apply((DataSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String s3Bucket;
        private List<String> s3Keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfig model) {
            this.name(model.name);
            this.s3Bucket(model.s3Bucket);
            this.s3Keys(model.s3Keys);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final Collection<String> getS3Keys() {
            if (this.s3Keys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.s3Keys;
        }

        @Override
        public final Builder s3Keys(Collection<String> s3Keys) {
            this.s3Keys = S3KeysCopier.copy(s3Keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Keys(String ... s3Keys) {
            this.s3Keys(Arrays.asList(s3Keys));
            return this;
        }

        public final void setS3Keys(Collection<String> s3Keys) {
            this.s3Keys = S3KeysCopier.copy(s3Keys);
        }

        public DataSourceConfig build() {
            return new DataSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfig> {
        public Builder name(String var1);

        public Builder s3Bucket(String var1);

        public Builder s3Keys(Collection<String> var1);

        public Builder s3Keys(String ... var1);
    }
}

