/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.robomaker.model.ArnsCopier;
import software.amazon.awssdk.services.robomaker.model.OutputLocation;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.services.robomaker.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWorldExportJobRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, CreateWorldExportJobRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateWorldExportJobRequest.getter(CreateWorldExportJobRequest::clientRequestToken)).setter(CreateWorldExportJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<String>> WORLDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("worlds").getter(CreateWorldExportJobRequest.getter(CreateWorldExportJobRequest::worlds)).setter(CreateWorldExportJobRequest.setter(Builder::worlds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worlds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputLocation").getter(CreateWorldExportJobRequest.getter(CreateWorldExportJobRequest::outputLocation)).setter(CreateWorldExportJobRequest.setter(Builder::outputLocation)).constructor(OutputLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamRole").getter(CreateWorldExportJobRequest.getter(CreateWorldExportJobRequest::iamRole)).setter(CreateWorldExportJobRequest.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateWorldExportJobRequest.getter(CreateWorldExportJobRequest::tags)).setter(CreateWorldExportJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, WORLDS_FIELD, OUTPUT_LOCATION_FIELD, IAM_ROLE_FIELD, TAGS_FIELD));
    private final String clientRequestToken;
    private final List<String> worlds;
    private final OutputLocation outputLocation;
    private final String iamRole;
    private final Map<String, String> tags;

    private CreateWorldExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.worlds = builder.worlds;
        this.outputLocation = builder.outputLocation;
        this.iamRole = builder.iamRole;
        this.tags = builder.tags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasWorlds() {
        return this.worlds != null && !(this.worlds instanceof SdkAutoConstructList);
    }

    public final List<String> worlds() {
        return this.worlds;
    }

    public final OutputLocation outputLocation() {
        return this.outputLocation;
    }

    public final String iamRole() {
        return this.iamRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorlds() ? this.worlds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorldExportJobRequest)) {
            return false;
        }
        CreateWorldExportJobRequest other = (CreateWorldExportJobRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasWorlds() == other.hasWorlds() && Objects.equals(this.worlds(), other.worlds()) && Objects.equals(this.outputLocation(), other.outputLocation()) && Objects.equals(this.iamRole(), other.iamRole()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWorldExportJobRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("Worlds", this.hasWorlds() ? this.worlds() : null).add("OutputLocation", (Object)this.outputLocation()).add("IamRole", (Object)this.iamRole()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "worlds": {
                return Optional.ofNullable(clazz.cast(this.worlds()));
            }
            case "outputLocation": {
                return Optional.ofNullable(clazz.cast(this.outputLocation()));
            }
            case "iamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorldExportJobRequest, T> g) {
        return obj -> g.apply((CreateWorldExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private List<String> worlds = DefaultSdkAutoConstructList.getInstance();
        private OutputLocation outputLocation;
        private String iamRole;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorldExportJobRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.worlds(model.worlds);
            this.outputLocation(model.outputLocation);
            this.iamRole(model.iamRole);
            this.tags(model.tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<String> getWorlds() {
            if (this.worlds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.worlds;
        }

        @Override
        public final Builder worlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worlds(String ... worlds) {
            this.worlds(Arrays.asList(worlds));
            return this;
        }

        public final void setWorlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
        }

        public final OutputLocation.Builder getOutputLocation() {
            return this.outputLocation != null ? this.outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorldExportJobRequest build() {
            return new CreateWorldExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWorldExportJobRequest> {
        public Builder clientRequestToken(String var1);

        public Builder worlds(Collection<String> var1);

        public Builder worlds(String ... var1);

        public Builder outputLocation(OutputLocation var1);

        default public Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return this.outputLocation((OutputLocation)((OutputLocation.Builder)OutputLocation.builder().applyMutation(outputLocation)).build());
        }

        public Builder iamRole(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

