/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.LaunchConfig;
import software.amazon.awssdk.services.robomaker.model.UploadConfiguration;
import software.amazon.awssdk.services.robomaker.model.UploadConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RobotApplicationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RobotApplicationConfig> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("application").getter(RobotApplicationConfig.getter(RobotApplicationConfig::application)).setter(RobotApplicationConfig.setter(Builder::application)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()}).build();
    private static final SdkField<String> APPLICATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationVersion").getter(RobotApplicationConfig.getter(RobotApplicationConfig::applicationVersion)).setter(RobotApplicationConfig.setter(Builder::applicationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build()}).build();
    private static final SdkField<LaunchConfig> LAUNCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchConfig").getter(RobotApplicationConfig.getter(RobotApplicationConfig::launchConfig)).setter(RobotApplicationConfig.setter(Builder::launchConfig)).constructor(LaunchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfig").build()}).build();
    private static final SdkField<List<UploadConfiguration>> UPLOAD_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("uploadConfigurations").getter(RobotApplicationConfig.getter(RobotApplicationConfig::uploadConfigurations)).setter(RobotApplicationConfig.setter(Builder::uploadConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UploadConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEFAULT_UPLOAD_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useDefaultUploadConfigurations").getter(RobotApplicationConfig.getter(RobotApplicationConfig::useDefaultUploadConfigurations)).setter(RobotApplicationConfig.setter(Builder::useDefaultUploadConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDefaultUploadConfigurations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD, APPLICATION_VERSION_FIELD, LAUNCH_CONFIG_FIELD, UPLOAD_CONFIGURATIONS_FIELD, USE_DEFAULT_UPLOAD_CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String application;
    private final String applicationVersion;
    private final LaunchConfig launchConfig;
    private final List<UploadConfiguration> uploadConfigurations;
    private final Boolean useDefaultUploadConfigurations;

    private RobotApplicationConfig(BuilderImpl builder) {
        this.application = builder.application;
        this.applicationVersion = builder.applicationVersion;
        this.launchConfig = builder.launchConfig;
        this.uploadConfigurations = builder.uploadConfigurations;
        this.useDefaultUploadConfigurations = builder.useDefaultUploadConfigurations;
    }

    public final String application() {
        return this.application;
    }

    public final String applicationVersion() {
        return this.applicationVersion;
    }

    public final LaunchConfig launchConfig() {
        return this.launchConfig;
    }

    public final boolean hasUploadConfigurations() {
        return this.uploadConfigurations != null && !(this.uploadConfigurations instanceof SdkAutoConstructList);
    }

    public final List<UploadConfiguration> uploadConfigurations() {
        return this.uploadConfigurations;
    }

    public final Boolean useDefaultUploadConfigurations() {
        return this.useDefaultUploadConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.application());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUploadConfigurations() ? this.uploadConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaultUploadConfigurations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RobotApplicationConfig)) {
            return false;
        }
        RobotApplicationConfig other = (RobotApplicationConfig)obj;
        return Objects.equals(this.application(), other.application()) && Objects.equals(this.applicationVersion(), other.applicationVersion()) && Objects.equals(this.launchConfig(), other.launchConfig()) && this.hasUploadConfigurations() == other.hasUploadConfigurations() && Objects.equals(this.uploadConfigurations(), other.uploadConfigurations()) && Objects.equals(this.useDefaultUploadConfigurations(), other.useDefaultUploadConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"RobotApplicationConfig").add("Application", (Object)this.application()).add("ApplicationVersion", (Object)this.applicationVersion()).add("LaunchConfig", (Object)this.launchConfig()).add("UploadConfigurations", this.hasUploadConfigurations() ? this.uploadConfigurations() : null).add("UseDefaultUploadConfigurations", (Object)this.useDefaultUploadConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "application": {
                return Optional.ofNullable(clazz.cast(this.application()));
            }
            case "applicationVersion": {
                return Optional.ofNullable(clazz.cast(this.applicationVersion()));
            }
            case "launchConfig": {
                return Optional.ofNullable(clazz.cast(this.launchConfig()));
            }
            case "uploadConfigurations": {
                return Optional.ofNullable(clazz.cast(this.uploadConfigurations()));
            }
            case "useDefaultUploadConfigurations": {
                return Optional.ofNullable(clazz.cast(this.useDefaultUploadConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RobotApplicationConfig, T> g) {
        return obj -> g.apply((RobotApplicationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String application;
        private String applicationVersion;
        private LaunchConfig launchConfig;
        private List<UploadConfiguration> uploadConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Boolean useDefaultUploadConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(RobotApplicationConfig model) {
            this.application(model.application);
            this.applicationVersion(model.applicationVersion);
            this.launchConfig(model.launchConfig);
            this.uploadConfigurations(model.uploadConfigurations);
            this.useDefaultUploadConfigurations(model.useDefaultUploadConfigurations);
        }

        public final String getApplication() {
            return this.application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getApplicationVersion() {
            return this.applicationVersion;
        }

        @Override
        public final Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        public final LaunchConfig.Builder getLaunchConfig() {
            return this.launchConfig != null ? this.launchConfig.toBuilder() : null;
        }

        @Override
        public final Builder launchConfig(LaunchConfig launchConfig) {
            this.launchConfig = launchConfig;
            return this;
        }

        public final void setLaunchConfig(LaunchConfig.BuilderImpl launchConfig) {
            this.launchConfig = launchConfig != null ? launchConfig.build() : null;
        }

        public final Collection<UploadConfiguration.Builder> getUploadConfigurations() {
            if (this.uploadConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.uploadConfigurations != null ? (Collection)this.uploadConfigurations.stream().map(UploadConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder uploadConfigurations(Collection<UploadConfiguration> uploadConfigurations) {
            this.uploadConfigurations = UploadConfigurationsCopier.copy(uploadConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadConfigurations(UploadConfiguration ... uploadConfigurations) {
            this.uploadConfigurations(Arrays.asList(uploadConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder uploadConfigurations(Consumer<UploadConfiguration.Builder> ... uploadConfigurations) {
            this.uploadConfigurations(Stream.of(uploadConfigurations).map(c -> (UploadConfiguration)((UploadConfiguration.Builder)UploadConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUploadConfigurations(Collection<UploadConfiguration.BuilderImpl> uploadConfigurations) {
            this.uploadConfigurations = UploadConfigurationsCopier.copyFromBuilder(uploadConfigurations);
        }

        public final Boolean getUseDefaultUploadConfigurations() {
            return this.useDefaultUploadConfigurations;
        }

        @Override
        public final Builder useDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
            this.useDefaultUploadConfigurations = useDefaultUploadConfigurations;
            return this;
        }

        public final void setUseDefaultUploadConfigurations(Boolean useDefaultUploadConfigurations) {
            this.useDefaultUploadConfigurations = useDefaultUploadConfigurations;
        }

        public RobotApplicationConfig build() {
            return new RobotApplicationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RobotApplicationConfig> {
        public Builder application(String var1);

        public Builder applicationVersion(String var1);

        public Builder launchConfig(LaunchConfig var1);

        default public Builder launchConfig(Consumer<LaunchConfig.Builder> launchConfig) {
            return this.launchConfig((LaunchConfig)((LaunchConfig.Builder)LaunchConfig.builder().applyMutation(launchConfig)).build());
        }

        public Builder uploadConfigurations(Collection<UploadConfiguration> var1);

        public Builder uploadConfigurations(UploadConfiguration ... var1);

        public Builder uploadConfigurations(Consumer<UploadConfiguration.Builder> ... var1);

        public Builder useDefaultUploadConfigurations(Boolean var1);
    }
}

