/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.robomaker.model.PortMapping;
import software.amazon.awssdk.services.robomaker.model.PortMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortForwardingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortForwardingConfig> {
    private static final SdkField<List<PortMapping>> PORT_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portMappings").getter(PortForwardingConfig.getter(PortForwardingConfig::portMappings)).setter(PortForwardingConfig.setter(Builder::portMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_MAPPINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PortMapping> portMappings;

    private PortForwardingConfig(BuilderImpl builder) {
        this.portMappings = builder.portMappings;
    }

    public boolean hasPortMappings() {
        return this.portMappings != null && !(this.portMappings instanceof SdkAutoConstructList);
    }

    public List<PortMapping> portMappings() {
        return this.portMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortMappings() ? this.portMappings() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortForwardingConfig)) {
            return false;
        }
        PortForwardingConfig other = (PortForwardingConfig)obj;
        return this.hasPortMappings() == other.hasPortMappings() && Objects.equals(this.portMappings(), other.portMappings());
    }

    public String toString() {
        return ToString.builder((String)"PortForwardingConfig").add("PortMappings", this.hasPortMappings() ? this.portMappings() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portMappings": {
                return Optional.ofNullable(clazz.cast(this.portMappings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortForwardingConfig, T> g) {
        return obj -> g.apply((PortForwardingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PortMapping> portMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PortForwardingConfig model) {
            this.portMappings(model.portMappings);
        }

        public final Collection<PortMapping.Builder> getPortMappings() {
            if (this.portMappings instanceof SdkAutoConstructList) {
                return null;
            }
            return this.portMappings != null ? (Collection)this.portMappings.stream().map(PortMapping::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portMappings(Collection<PortMapping> portMappings) {
            this.portMappings = PortMappingListCopier.copy(portMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(PortMapping ... portMappings) {
            this.portMappings(Arrays.asList(portMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(Consumer<PortMapping.Builder> ... portMappings) {
            this.portMappings(Stream.of(portMappings).map(c -> (PortMapping)((PortMapping.Builder)PortMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortMappings(Collection<PortMapping.BuilderImpl> portMappings) {
            this.portMappings = PortMappingListCopier.copyFromBuilder(portMappings);
        }

        public PortForwardingConfig build() {
            return new PortForwardingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortForwardingConfig> {
        public Builder portMappings(Collection<PortMapping> var1);

        public Builder portMappings(PortMapping ... var1);

        public Builder portMappings(Consumer<PortMapping.Builder> ... var1);
    }
}

