/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.RoboMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorldTemplateBodyRequest
extends RoboMakerRequest
implements ToCopyableBuilder<Builder, GetWorldTemplateBodyRequest> {
    private static final SdkField<String> TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("template").getter(GetWorldTemplateBodyRequest.getter(GetWorldTemplateBodyRequest::template)).setter(GetWorldTemplateBodyRequest.setter(Builder::template)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()}).build();
    private static final SdkField<String> GENERATION_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationJob").getter(GetWorldTemplateBodyRequest.getter(GetWorldTemplateBodyRequest::generationJob)).setter(GetWorldTemplateBodyRequest.setter(Builder::generationJob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationJob").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_FIELD, GENERATION_JOB_FIELD));
    private final String template;
    private final String generationJob;

    private GetWorldTemplateBodyRequest(BuilderImpl builder) {
        super(builder);
        this.template = builder.template;
        this.generationJob = builder.generationJob;
    }

    public String template() {
        return this.template;
    }

    public String generationJob() {
        return this.generationJob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.template());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationJob());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorldTemplateBodyRequest)) {
            return false;
        }
        GetWorldTemplateBodyRequest other = (GetWorldTemplateBodyRequest)((Object)obj);
        return Objects.equals(this.template(), other.template()) && Objects.equals(this.generationJob(), other.generationJob());
    }

    public String toString() {
        return ToString.builder((String)"GetWorldTemplateBodyRequest").add("Template", (Object)this.template()).add("GenerationJob", (Object)this.generationJob()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "template": {
                return Optional.ofNullable(clazz.cast(this.template()));
            }
            case "generationJob": {
                return Optional.ofNullable(clazz.cast(this.generationJob()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWorldTemplateBodyRequest, T> g) {
        return obj -> g.apply((GetWorldTemplateBodyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RoboMakerRequest.BuilderImpl
    implements Builder {
        private String template;
        private String generationJob;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorldTemplateBodyRequest model) {
            super(model);
            this.template(model.template);
            this.generationJob(model.generationJob);
        }

        public final String getTemplate() {
            return this.template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        public final String getGenerationJob() {
            return this.generationJob;
        }

        @Override
        public final Builder generationJob(String generationJob) {
            this.generationJob = generationJob;
            return this;
        }

        public final void setGenerationJob(String generationJob) {
            this.generationJob = generationJob;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorldTemplateBodyRequest build() {
            return new GetWorldTemplateBodyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RoboMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorldTemplateBodyRequest> {
        public Builder template(String var1);

        public Builder generationJob(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

