/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerClient;
import software.amazon.awssdk.services.robomaker.model.ListWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.WorldSummary;

public class ListWorldsIterable
implements SdkIterable<ListWorldsResponse> {
    private final RoboMakerClient client;
    private final ListWorldsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorldsIterable(RoboMakerClient client, ListWorldsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorldsResponseFetcher();
    }

    public Iterator<ListWorldsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorldSummary> worldSummaries() {
        Function<ListWorldsResponse, Iterator> getIterator = response -> {
            if (response != null && response.worldSummaries() != null) {
                return response.worldSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorldsResponseFetcher
    implements SyncPageFetcher<ListWorldsResponse> {
        private ListWorldsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorldsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorldsResponse nextPage(ListWorldsResponse previousPage) {
            if (previousPage == null) {
                return ListWorldsIterable.this.client.listWorlds(ListWorldsIterable.this.firstRequest);
            }
            return ListWorldsIterable.this.client.listWorlds((ListWorldsRequest)((Object)ListWorldsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

