/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsClient;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse;

public class ListGroupsIterable
implements SdkIterable<ListGroupsResponse> {
    private final ResourceGroupsClient client;
    private final ListGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupsIterable(ResourceGroupsClient client, ListGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupsResponseFetcher();
    }

    public Iterator<ListGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListGroupsIterable resume(ListGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListGroupsIterable(this.client, (ListGroupsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListGroupsResponseFetcher
    implements SyncPageFetcher<ListGroupsResponse> {
        private ListGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupsResponse nextPage(ListGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsIterable.this.client.listGroups(ListGroupsIterable.this.firstRequest);
            }
            return ListGroupsIterable.this.client.listGroups((ListGroupsRequest)((Object)ListGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

