/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsAsyncClient;
import software.amazon.awssdk.services.resourcegroups.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier;
import software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse;

public class SearchResourcesPublisher
implements SdkPublisher<SearchResourcesResponse> {
    private final ResourceGroupsAsyncClient client;
    private final SearchResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchResourcesPublisher(ResourceGroupsAsyncClient client, SearchResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchResourcesPublisher(ResourceGroupsAsyncClient client, SearchResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceIdentifier> resourceIdentifiers() {
        Function<SearchResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceIdentifiers() != null) {
                return response.resourceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchResourcesResponseFetcher
    implements AsyncPageFetcher<SearchResourcesResponse> {
        private SearchResourcesResponseFetcher() {
        }

        public boolean hasNextPage(SearchResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchResourcesResponse> nextPage(SearchResourcesResponse previousPage) {
            if (previousPage == null) {
                return SearchResourcesPublisher.this.client.searchResources(SearchResourcesPublisher.this.firstRequest);
            }
            return SearchResourcesPublisher.this.client.searchResources((SearchResourcesRequest)((Object)SearchResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

