/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesItem;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesItemListCopier;
import software.amazon.awssdk.services.resourcegroups.model.QueryError;
import software.amazon.awssdk.services.resourcegroups.model.QueryErrorListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsResponse;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupResourcesResponse
extends ResourceGroupsResponse
implements ToCopyableBuilder<Builder, ListGroupResourcesResponse> {
    private static final SdkField<List<ListGroupResourcesItem>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(ListGroupResourcesResponse.getter(ListGroupResourcesResponse::resources)).setter(ListGroupResourcesResponse.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListGroupResourcesItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIdentifiers").getter(ListGroupResourcesResponse.getter(ListGroupResourcesResponse::resourceIdentifiers)).setter(ListGroupResourcesResponse.setter(Builder::resourceIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupResourcesResponse.getter(ListGroupResourcesResponse::nextToken)).setter(ListGroupResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<QueryError>> QUERY_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryErrors").getter(ListGroupResourcesResponse.getter(ListGroupResourcesResponse::queryErrors)).setter(ListGroupResourcesResponse.setter(Builder::queryErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCES_FIELD, RESOURCE_IDENTIFIERS_FIELD, NEXT_TOKEN_FIELD, QUERY_ERRORS_FIELD));
    private final List<ListGroupResourcesItem> resources;
    private final List<ResourceIdentifier> resourceIdentifiers;
    private final String nextToken;
    private final List<QueryError> queryErrors;

    private ListGroupResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resources = builder.resources;
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
        this.queryErrors = builder.queryErrors;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<ListGroupResourcesItem> resources() {
        return this.resources;
    }

    @Deprecated
    public final boolean hasResourceIdentifiers() {
        return this.resourceIdentifiers != null && !(this.resourceIdentifiers instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<ResourceIdentifier> resourceIdentifiers() {
        return this.resourceIdentifiers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasQueryErrors() {
        return this.queryErrors != null && !(this.queryErrors instanceof SdkAutoConstructList);
    }

    public final List<QueryError> queryErrors() {
        return this.queryErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryErrors() ? this.queryErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupResourcesResponse)) {
            return false;
        }
        ListGroupResourcesResponse other = (ListGroupResourcesResponse)((Object)obj);
        return this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && this.hasResourceIdentifiers() == other.hasResourceIdentifiers() && Objects.equals(this.resourceIdentifiers(), other.resourceIdentifiers()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasQueryErrors() == other.hasQueryErrors() && Objects.equals(this.queryErrors(), other.queryErrors());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupResourcesResponse").add("Resources", this.hasResources() ? this.resources() : null).add("ResourceIdentifiers", this.hasResourceIdentifiers() ? this.resourceIdentifiers() : null).add("NextToken", (Object)this.nextToken()).add("QueryErrors", this.hasQueryErrors() ? this.queryErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "ResourceIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifiers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "QueryErrors": {
                return Optional.ofNullable(clazz.cast(this.queryErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupResourcesResponse, T> g) {
        return obj -> g.apply((ListGroupResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsResponse.BuilderImpl
    implements Builder {
        private List<ListGroupResourcesItem> resources = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<QueryError> queryErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupResourcesResponse model) {
            super(model);
            this.resources(model.resources);
            this.resourceIdentifiers(model.resourceIdentifiers);
            this.nextToken(model.nextToken);
            this.queryErrors(model.queryErrors);
        }

        public final List<ListGroupResourcesItem.Builder> getResources() {
            List<ListGroupResourcesItem.Builder> result = ListGroupResourcesItemListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<ListGroupResourcesItem.BuilderImpl> resources) {
            this.resources = ListGroupResourcesItemListCopier.copyFromBuilder(resources);
        }

        @Override
        @Transient
        public final Builder resources(Collection<ListGroupResourcesItem> resources) {
            this.resources = ListGroupResourcesItemListCopier.copy(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(ListGroupResourcesItem ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(Consumer<ListGroupResourcesItem.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (ListGroupResourcesItem)((ListGroupResourcesItem.Builder)ListGroupResourcesItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final List<ResourceIdentifier.Builder> getResourceIdentifiers() {
            List<ResourceIdentifier.Builder> result = ResourceIdentifierListCopier.copyToBuilder(this.resourceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setResourceIdentifiers(Collection<ResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copyFromBuilder(resourceIdentifiers);
        }

        @Override
        @Transient
        @Deprecated
        public final Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        @Deprecated
        public final Builder resourceIdentifiers(ResourceIdentifier ... resourceIdentifiers) {
            this.resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        @Deprecated
        public final Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder> ... resourceIdentifiers) {
            this.resourceIdentifiers(Stream.of(resourceIdentifiers).map(c -> (ResourceIdentifier)((ResourceIdentifier.Builder)ResourceIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QueryError.Builder> getQueryErrors() {
            List<QueryError.Builder> result = QueryErrorListCopier.copyToBuilder(this.queryErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryErrors(Collection<QueryError.BuilderImpl> queryErrors) {
            this.queryErrors = QueryErrorListCopier.copyFromBuilder(queryErrors);
        }

        @Override
        @Transient
        public final Builder queryErrors(Collection<QueryError> queryErrors) {
            this.queryErrors = QueryErrorListCopier.copy(queryErrors);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryErrors(QueryError ... queryErrors) {
            this.queryErrors(Arrays.asList(queryErrors));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryErrors(Consumer<QueryError.Builder> ... queryErrors) {
            this.queryErrors(Stream.of(queryErrors).map(c -> (QueryError)((QueryError.Builder)QueryError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListGroupResourcesResponse build() {
            return new ListGroupResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupResourcesResponse> {
        public Builder resources(Collection<ListGroupResourcesItem> var1);

        public Builder resources(ListGroupResourcesItem ... var1);

        public Builder resources(Consumer<ListGroupResourcesItem.Builder> ... var1);

        @Deprecated
        public Builder resourceIdentifiers(Collection<ResourceIdentifier> var1);

        @Deprecated
        public Builder resourceIdentifiers(ResourceIdentifier ... var1);

        @Deprecated
        public Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder queryErrors(Collection<QueryError> var1);

        public Builder queryErrors(QueryError ... var1);

        public Builder queryErrors(Consumer<QueryError.Builder> ... var1);
    }
}

