/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resourcegroups.model.FailedResource;
import software.amazon.awssdk.services.resourcegroups.model.FailedResourceListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceArnListCopier;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupResourcesResponse
extends ResourceGroupsResponse
implements ToCopyableBuilder<Builder, GroupResourcesResponse> {
    private static final SdkField<List<String>> SUCCEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Succeeded").getter(GroupResourcesResponse.getter(GroupResourcesResponse::succeeded)).setter(GroupResourcesResponse.setter(Builder::succeeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Succeeded").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedResource>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(GroupResourcesResponse.getter(GroupResourcesResponse::failed)).setter(GroupResourcesResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCEEDED_FIELD, FAILED_FIELD));
    private final List<String> succeeded;
    private final List<FailedResource> failed;

    private GroupResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.succeeded = builder.succeeded;
        this.failed = builder.failed;
    }

    public boolean hasSucceeded() {
        return this.succeeded != null && !(this.succeeded instanceof SdkAutoConstructList);
    }

    public List<String> succeeded() {
        return this.succeeded;
    }

    public boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public List<FailedResource> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSucceeded() ? this.succeeded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupResourcesResponse)) {
            return false;
        }
        GroupResourcesResponse other = (GroupResourcesResponse)((Object)obj);
        return this.hasSucceeded() == other.hasSucceeded() && Objects.equals(this.succeeded(), other.succeeded()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public String toString() {
        return ToString.builder((String)"GroupResourcesResponse").add("Succeeded", this.hasSucceeded() ? this.succeeded() : null).add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Succeeded": {
                return Optional.ofNullable(clazz.cast(this.succeeded()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupResourcesResponse, T> g) {
        return obj -> g.apply((GroupResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResourceGroupsResponse.BuilderImpl
    implements Builder {
        private List<String> succeeded = DefaultSdkAutoConstructList.getInstance();
        private List<FailedResource> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupResourcesResponse model) {
            super(model);
            this.succeeded(model.succeeded);
            this.failed(model.failed);
        }

        public final Collection<String> getSucceeded() {
            if (this.succeeded instanceof SdkAutoConstructList) {
                return null;
            }
            return this.succeeded;
        }

        @Override
        public final Builder succeeded(Collection<String> succeeded) {
            this.succeeded = ResourceArnListCopier.copy(succeeded);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder succeeded(String ... succeeded) {
            this.succeeded(Arrays.asList(succeeded));
            return this;
        }

        public final void setSucceeded(Collection<String> succeeded) {
            this.succeeded = ResourceArnListCopier.copy(succeeded);
        }

        public final Collection<FailedResource.Builder> getFailed() {
            if (this.failed instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failed != null ? (Collection)this.failed.stream().map(FailedResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failed(Collection<FailedResource> failed) {
            this.failed = FailedResourceListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(FailedResource ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<FailedResource.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (FailedResource)((FailedResource.Builder)FailedResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailed(Collection<FailedResource.BuilderImpl> failed) {
            this.failed = FailedResourceListCopier.copyFromBuilder(failed);
        }

        @Override
        public GroupResourcesResponse build() {
            return new GroupResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResourceGroupsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GroupResourcesResponse> {
        public Builder succeeded(Collection<String> var1);

        public Builder succeeded(String ... var1);

        public Builder failed(Collection<FailedResource> var1);

        public Builder failed(FailedResource ... var1);

        public Builder failed(Consumer<FailedResource.Builder> ... var1);
    }
}

