/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceIdentifierMarshaller {
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").isBinary(false).build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").isBinary(false).build();
    private static final ResourceIdentifierMarshaller INSTANCE = new ResourceIdentifierMarshaller();

    private ResourceIdentifierMarshaller() {
    }

    public static ResourceIdentifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceIdentifier resourceIdentifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceIdentifier, (String)"resourceIdentifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceIdentifier.resourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.resourceType(), RESOURCETYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

