/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.resourcegroups.model.Group;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GroupMarshaller {
    private static final MarshallingInfo<String> GROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupArn").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final GroupMarshaller INSTANCE = new GroupMarshaller();

    private GroupMarshaller() {
    }

    public static GroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Group group, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)group, (String)"group");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)group.groupArn(), GROUPARN_BINDING);
            protocolMarshaller.marshall((Object)group.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)group.description(), DESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

