/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListResourcesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.Resource;

public class ListResourcesIterable
implements SdkIterable<ListResourcesResponse> {
    private final ResourceExplorer2Client client;
    private final ListResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourcesIterable(ResourceExplorer2Client client, ListResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourcesResponseFetcher();
    }

    public Iterator<ListResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Resource> resources() {
        Function<ListResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourcesResponseFetcher
    implements SyncPageFetcher<ListResourcesResponse> {
        private ListResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourcesResponse nextPage(ListResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListResourcesIterable.this.client.listResources(ListResourcesIterable.this.firstRequest);
            }
            return ListResourcesIterable.this.client.listResources((ListResourcesRequest)((Object)ListResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

