/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsResponse;

public class ListManagedViewsIterable
implements SdkIterable<ListManagedViewsResponse> {
    private final ResourceExplorer2Client client;
    private final ListManagedViewsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedViewsIterable(ResourceExplorer2Client client, ListManagedViewsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListManagedViewsResponseFetcher();
    }

    public Iterator<ListManagedViewsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> managedViews() {
        Function<ListManagedViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedViews() != null) {
                return response.managedViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedViewsResponseFetcher
    implements SyncPageFetcher<ListManagedViewsResponse> {
        private ListManagedViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedViewsResponse nextPage(ListManagedViewsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedViewsIterable.this.client.listManagedViews(ListManagedViewsIterable.this.firstRequest);
            }
            return ListManagedViewsIterable.this.client.listManagedViews((ListManagedViewsRequest)((Object)ListManagedViewsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

