/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an Amazon Web Services service that has been granted streaming access to your Resource
 * Explorer data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingAccessDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingAccessDetails.Builder, StreamingAccessDetails> {
    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServicePrincipal").getter(getter(StreamingAccessDetails::servicePrincipal))
            .setter(setter(Builder::servicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(StreamingAccessDetails::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_PRINCIPAL_FIELD,
            CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String servicePrincipal;

    private final Instant createdAt;

    private StreamingAccessDetails(BuilderImpl builder) {
        this.servicePrincipal = builder.servicePrincipal;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The service principal of the Amazon Web Services service that has streaming access to your Resource Explorer
     * data. A service principal is a unique identifier for an Amazon Web Services service.
     * </p>
     * 
     * @return The service principal of the Amazon Web Services service that has streaming access to your Resource
     *         Explorer data. A service principal is a unique identifier for an Amazon Web Services service.
     */
    public final String servicePrincipal() {
        return servicePrincipal;
    }

    /**
     * <p>
     * The date and time when streaming access was granted to the Amazon Web Services service, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time when streaming access was granted to the Amazon Web Services service, in ISO 8601
     *         format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingAccessDetails)) {
            return false;
        }
        StreamingAccessDetails other = (StreamingAccessDetails) obj;
        return Objects.equals(servicePrincipal(), other.servicePrincipal()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingAccessDetails").add("ServicePrincipal", servicePrincipal())
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServicePrincipal":
            return Optional.ofNullable(clazz.cast(servicePrincipal()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServicePrincipal", SERVICE_PRINCIPAL_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamingAccessDetails, T> g) {
        return obj -> g.apply((StreamingAccessDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingAccessDetails> {
        /**
         * <p>
         * The service principal of the Amazon Web Services service that has streaming access to your Resource Explorer
         * data. A service principal is a unique identifier for an Amazon Web Services service.
         * </p>
         * 
         * @param servicePrincipal
         *        The service principal of the Amazon Web Services service that has streaming access to your Resource
         *        Explorer data. A service principal is a unique identifier for an Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(String servicePrincipal);

        /**
         * <p>
         * The date and time when streaming access was granted to the Amazon Web Services service, in ISO 8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time when streaming access was granted to the Amazon Web Services service, in ISO 8601
         *        format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String servicePrincipal;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingAccessDetails model) {
            servicePrincipal(model.servicePrincipal);
            createdAt(model.createdAt);
        }

        public final String getServicePrincipal() {
            return servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public StreamingAccessDetails build() {
            return new StreamingAccessDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
