/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the status of a Resource Explorer index operation in a specific Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexStatus implements SdkPojo, Serializable, ToCopyableBuilder<IndexStatus.Builder, IndexStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(IndexStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Index> INDEX_FIELD = SdkField.<Index> builder(MarshallingType.SDK_POJO).memberName("Index")
            .getter(getter(IndexStatus::index)).setter(setter(Builder::index)).constructor(Index::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorDetails").getter(getter(IndexStatus::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, INDEX_FIELD,
            ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Index index;

    private final ErrorDetails errorDetails;

    private IndexStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.index = builder.index;
        this.errorDetails = builder.errorDetails;
    }

    /**
     * <p>
     * The current status of the index operation. Valid values are <code>SUCCEEDED</code>, <code>FAILED</code>,
     * <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index operation. Valid values are <code>SUCCEEDED</code>, <code>FAILED</code>,
     *         <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
     * @see OperationStatus
     */
    public final OperationStatus status() {
        return OperationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the index operation. Valid values are <code>SUCCEEDED</code>, <code>FAILED</code>,
     * <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OperationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the index operation. Valid values are <code>SUCCEEDED</code>, <code>FAILED</code>,
     *         <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
     * @see OperationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the Index property for this object.
     * 
     * @return The value of the Index property for this object.
     */
    public final Index index() {
        return index;
    }

    /**
     * <p>
     * Details about any error that occurred during the index operation.
     * </p>
     * 
     * @return Details about any error that occurred during the index operation.
     */
    public final ErrorDetails errorDetails() {
        return errorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexStatus)) {
            return false;
        }
        IndexStatus other = (IndexStatus) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(index(), other.index())
                && Objects.equals(errorDetails(), other.errorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IndexStatus").add("Status", statusAsString()).add("Index", index())
                .add("ErrorDetails", errorDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("Index", INDEX_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IndexStatus, T> g) {
        return obj -> g.apply((IndexStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexStatus> {
        /**
         * <p>
         * The current status of the index operation. Valid values are <code>SUCCEEDED</code>, <code>FAILED</code>,
         * <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the index operation. Valid values are <code>SUCCEEDED</code>,
         *        <code>FAILED</code>, <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the index operation. Valid values are <code>SUCCEEDED</code>, <code>FAILED</code>,
         * <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the index operation. Valid values are <code>SUCCEEDED</code>,
         *        <code>FAILED</code>, <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
         * @see OperationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperationStatus
         */
        Builder status(OperationStatus status);

        /**
         * Sets the value of the Index property for this object.
         *
         * @param index
         *        The new value for the Index property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Index index);

        /**
         * Sets the value of the Index property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Index.Builder} avoiding the need to
         * create one manually via {@link Index#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Index.Builder#build()} is called immediately and its result is
         * passed to {@link #index(Index)}.
         * 
         * @param index
         *        a consumer that will call methods on {@link Index.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #index(Index)
         */
        default Builder index(Consumer<Index.Builder> index) {
            return index(Index.builder().applyMutation(index).build());
        }

        /**
         * <p>
         * Details about any error that occurred during the index operation.
         * </p>
         * 
         * @param errorDetails
         *        Details about any error that occurred during the index operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetails errorDetails);

        /**
         * <p>
         * Details about any error that occurred during the index operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(ErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ErrorDetails)
         */
        default Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return errorDetails(ErrorDetails.builder().applyMutation(errorDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Index index;

        private ErrorDetails errorDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexStatus model) {
            status(model.status);
            index(model.index);
            errorDetails(model.errorDetails);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Index.Builder getIndex() {
            return index != null ? index.toBuilder() : null;
        }

        public final void setIndex(Index.BuilderImpl index) {
            this.index = index != null ? index.build() : null;
        }

        @Override
        public final Builder index(Index index) {
            this.index = index;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @Override
        public IndexStatus build() {
            return new IndexStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
