/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceViewResponse extends ResourceExplorer2Response implements
        ToCopyableBuilder<GetServiceViewResponse.Builder, GetServiceViewResponse> {
    private static final SdkField<ServiceView> VIEW_FIELD = SdkField.<ServiceView> builder(MarshallingType.SDK_POJO)
            .memberName("View").getter(getter(GetServiceViewResponse::view)).setter(setter(Builder::view))
            .constructor(ServiceView::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("View").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIEW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ServiceView view;

    private GetServiceViewResponse(BuilderImpl builder) {
        super(builder);
        this.view = builder.view;
    }

    /**
     * <p>
     * A <code>ServiceView</code> object that contains the details and configuration of the requested service view.
     * </p>
     * 
     * @return A <code>ServiceView</code> object that contains the details and configuration of the requested service
     *         view.
     */
    public final ServiceView view() {
        return view;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(view());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceViewResponse)) {
            return false;
        }
        GetServiceViewResponse other = (GetServiceViewResponse) obj;
        return Objects.equals(view(), other.view());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceViewResponse").add("View", view()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "View":
            return Optional.ofNullable(clazz.cast(view()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("View", VIEW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceViewResponse, T> g) {
        return obj -> g.apply((GetServiceViewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceExplorer2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetServiceViewResponse> {
        /**
         * <p>
         * A <code>ServiceView</code> object that contains the details and configuration of the requested service view.
         * </p>
         * 
         * @param view
         *        A <code>ServiceView</code> object that contains the details and configuration of the requested service
         *        view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder view(ServiceView view);

        /**
         * <p>
         * A <code>ServiceView</code> object that contains the details and configuration of the requested service view.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceView.Builder} avoiding the need to
         * create one manually via {@link ServiceView#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceView.Builder#build()} is called immediately and its result
         * is passed to {@link #view(ServiceView)}.
         * 
         * @param view
         *        a consumer that will call methods on {@link ServiceView.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #view(ServiceView)
         */
        default Builder view(Consumer<ServiceView.Builder> view) {
            return view(ServiceView.builder().applyMutation(view).build());
        }
    }

    static final class BuilderImpl extends ResourceExplorer2Response.BuilderImpl implements Builder {
        private ServiceView view;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceViewResponse model) {
            super(model);
            view(model.view);
        }

        public final ServiceView.Builder getView() {
            return view != null ? view.toBuilder() : null;
        }

        public final void setView(ServiceView.BuilderImpl view) {
            this.view = view != null ? view.build() : null;
        }

        @Override
        public final Builder view(ServiceView view) {
            this.view = view;
            return this;
        }

        @Override
        public GetServiceViewResponse build() {
            return new GetServiceViewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
