/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.Index;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesResponse;

public class ListServiceIndexesIterable
implements SdkIterable<ListServiceIndexesResponse> {
    private final ResourceExplorer2Client client;
    private final ListServiceIndexesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceIndexesIterable(ResourceExplorer2Client client, ListServiceIndexesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceIndexesResponseFetcher();
    }

    public Iterator<ListServiceIndexesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Index> indexes() {
        Function<ListServiceIndexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.indexes() != null) {
                return response.indexes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceIndexesResponseFetcher
    implements SyncPageFetcher<ListServiceIndexesResponse> {
        private ListServiceIndexesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceIndexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceIndexesResponse nextPage(ListServiceIndexesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceIndexesIterable.this.client.listServiceIndexes(ListServiceIndexesIterable.this.firstRequest);
            }
            return ListServiceIndexesIterable.this.client.listServiceIndexes((ListServiceIndexesRequest)((Object)ListServiceIndexesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

