/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourceexplorer2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateViewRequest extends ResourceExplorer2Request implements
        ToCopyableBuilder<UpdateViewRequest.Builder, UpdateViewRequest> {
    private static final SdkField<SearchFilter> FILTERS_FIELD = SdkField.<SearchFilter> builder(MarshallingType.SDK_POJO)
            .memberName("Filters").getter(getter(UpdateViewRequest::filters)).setter(setter(Builder::filters))
            .constructor(SearchFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()).build();

    private static final SdkField<List<IncludedProperty>> INCLUDED_PROPERTIES_FIELD = SdkField
            .<List<IncludedProperty>> builder(MarshallingType.LIST)
            .memberName("IncludedProperties")
            .getter(getter(UpdateViewRequest::includedProperties))
            .setter(setter(Builder::includedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludedProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncludedProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncludedProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VIEW_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewArn").getter(getter(UpdateViewRequest::viewArn)).setter(setter(Builder::viewArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            INCLUDED_PROPERTIES_FIELD, VIEW_ARN_FIELD));

    private final SearchFilter filters;

    private final List<IncludedProperty> includedProperties;

    private final String viewArn;

    private UpdateViewRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.includedProperties = builder.includedProperties;
        this.viewArn = builder.viewArn;
    }

    /**
     * <p>
     * An array of strings that specify which resources are included in the results of queries made using this view.
     * When you use this view in a <a>Search</a> operation, the filter string is combined with the search's
     * <code>QueryString</code> parameter using a logical <code>AND</code> operator.
     * </p>
     * <p>
     * For information about the supported syntax, see <a
     * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html">Search query
     * reference for Resource Explorer</a> in the <i>Amazon Web Services Resource Explorer User Guide</i>.
     * </p>
     * <important>
     * <p>
     * This query string in the context of this operation supports only <a href=
     * "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters"
     * >filter prefixes</a> with optional <a href=
     * "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators"
     * >operators</a>. It doesn't support free-form text. For example, the string
     * <code>region:us* service:ec2 -tag:stage=prod</code> includes all Amazon EC2 resources in any Amazon Web Services
     * Region that begins with the letters <code>us</code> and is <i>not</i> tagged with a key <code>Stage</code> that
     * has the value <code>prod</code>.
     * </p>
     * </important>
     * 
     * @return An array of strings that specify which resources are included in the results of queries made using this
     *         view. When you use this view in a <a>Search</a> operation, the filter string is combined with the
     *         search's <code>QueryString</code> parameter using a logical <code>AND</code> operator.</p>
     *         <p>
     *         For information about the supported syntax, see <a
     *         href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html"
     *         >Search query reference for Resource Explorer</a> in the <i>Amazon Web Services Resource Explorer User
     *         Guide</i>.
     *         </p>
     *         <important>
     *         <p>
     *         This query string in the context of this operation supports only <a href=
     *         "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters"
     *         >filter prefixes</a> with optional <a href=
     *         "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators"
     *         >operators</a>. It doesn't support free-form text. For example, the string
     *         <code>region:us* service:ec2 -tag:stage=prod</code> includes all Amazon EC2 resources in any Amazon Web
     *         Services Region that begins with the letters <code>us</code> and is <i>not</i> tagged with a key
     *         <code>Stage</code> that has the value <code>prod</code>.
     *         </p>
     */
    public final SearchFilter filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncludedProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncludedProperties() {
        return includedProperties != null && !(includedProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies optional fields that you want included in search results from this view. It is a list of objects that
     * each describe a field to include.
     * </p>
     * <p>
     * The default is an empty list, with no optional fields included in the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncludedProperties} method.
     * </p>
     * 
     * @return Specifies optional fields that you want included in search results from this view. It is a list of
     *         objects that each describe a field to include.</p>
     *         <p>
     *         The default is an empty list, with no optional fields included in the results.
     */
    public final List<IncludedProperty> includedProperties() {
        return includedProperties;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
     * (ARN)</a> of the view that you want to modify.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource
     *         name (ARN)</a> of the view that you want to modify.
     */
    public final String viewArn() {
        return viewArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncludedProperties() ? includedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(viewArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateViewRequest)) {
            return false;
        }
        UpdateViewRequest other = (UpdateViewRequest) obj;
        return Objects.equals(filters(), other.filters()) && hasIncludedProperties() == other.hasIncludedProperties()
                && Objects.equals(includedProperties(), other.includedProperties()) && Objects.equals(viewArn(), other.viewArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateViewRequest").add("Filters", filters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IncludedProperties", hasIncludedProperties() ? includedProperties() : null).add("ViewArn", viewArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "IncludedProperties":
            return Optional.ofNullable(clazz.cast(includedProperties()));
        case "ViewArn":
            return Optional.ofNullable(clazz.cast(viewArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateViewRequest, T> g) {
        return obj -> g.apply((UpdateViewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceExplorer2Request.Builder, SdkPojo, CopyableBuilder<Builder, UpdateViewRequest> {
        /**
         * <p>
         * An array of strings that specify which resources are included in the results of queries made using this view.
         * When you use this view in a <a>Search</a> operation, the filter string is combined with the search's
         * <code>QueryString</code> parameter using a logical <code>AND</code> operator.
         * </p>
         * <p>
         * For information about the supported syntax, see <a
         * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html">Search
         * query reference for Resource Explorer</a> in the <i>Amazon Web Services Resource Explorer User Guide</i>.
         * </p>
         * <important>
         * <p>
         * This query string in the context of this operation supports only <a href=
         * "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters"
         * >filter prefixes</a> with optional <a href=
         * "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators"
         * >operators</a>. It doesn't support free-form text. For example, the string
         * <code>region:us* service:ec2 -tag:stage=prod</code> includes all Amazon EC2 resources in any Amazon Web
         * Services Region that begins with the letters <code>us</code> and is <i>not</i> tagged with a key
         * <code>Stage</code> that has the value <code>prod</code>.
         * </p>
         * </important>
         * 
         * @param filters
         *        An array of strings that specify which resources are included in the results of queries made using
         *        this view. When you use this view in a <a>Search</a> operation, the filter string is combined with the
         *        search's <code>QueryString</code> parameter using a logical <code>AND</code> operator.</p>
         *        <p>
         *        For information about the supported syntax, see <a
         *        href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html"
         *        >Search query reference for Resource Explorer</a> in the <i>Amazon Web Services Resource Explorer User
         *        Guide</i>.
         *        </p>
         *        <important>
         *        <p>
         *        This query string in the context of this operation supports only <a href=
         *        "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters"
         *        >filter prefixes</a> with optional <a href=
         *        "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators"
         *        >operators</a>. It doesn't support free-form text. For example, the string
         *        <code>region:us* service:ec2 -tag:stage=prod</code> includes all Amazon EC2 resources in any Amazon
         *        Web Services Region that begins with the letters <code>us</code> and is <i>not</i> tagged with a key
         *        <code>Stage</code> that has the value <code>prod</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(SearchFilter filters);

        /**
         * <p>
         * An array of strings that specify which resources are included in the results of queries made using this view.
         * When you use this view in a <a>Search</a> operation, the filter string is combined with the search's
         * <code>QueryString</code> parameter using a logical <code>AND</code> operator.
         * </p>
         * <p>
         * For information about the supported syntax, see <a
         * href="https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html">Search
         * query reference for Resource Explorer</a> in the <i>Amazon Web Services Resource Explorer User Guide</i>.
         * </p>
         * <important>
         * <p>
         * This query string in the context of this operation supports only <a href=
         * "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters"
         * >filter prefixes</a> with optional <a href=
         * "https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators"
         * >operators</a>. It doesn't support free-form text. For example, the string
         * <code>region:us* service:ec2 -tag:stage=prod</code> includes all Amazon EC2 resources in any Amazon Web
         * Services Region that begins with the letters <code>us</code> and is <i>not</i> tagged with a key
         * <code>Stage</code> that has the value <code>prod</code>.
         * </p>
         * </important> This is a convenience method that creates an instance of the {@link SearchFilter.Builder}
         * avoiding the need to create one manually via {@link SearchFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(SearchFilter)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link SearchFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(SearchFilter)
         */
        default Builder filters(Consumer<SearchFilter.Builder> filters) {
            return filters(SearchFilter.builder().applyMutation(filters).build());
        }

        /**
         * <p>
         * Specifies optional fields that you want included in search results from this view. It is a list of objects
         * that each describe a field to include.
         * </p>
         * <p>
         * The default is an empty list, with no optional fields included in the results.
         * </p>
         * 
         * @param includedProperties
         *        Specifies optional fields that you want included in search results from this view. It is a list of
         *        objects that each describe a field to include.</p>
         *        <p>
         *        The default is an empty list, with no optional fields included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedProperties(Collection<IncludedProperty> includedProperties);

        /**
         * <p>
         * Specifies optional fields that you want included in search results from this view. It is a list of objects
         * that each describe a field to include.
         * </p>
         * <p>
         * The default is an empty list, with no optional fields included in the results.
         * </p>
         * 
         * @param includedProperties
         *        Specifies optional fields that you want included in search results from this view. It is a list of
         *        objects that each describe a field to include.</p>
         *        <p>
         *        The default is an empty list, with no optional fields included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includedProperties(IncludedProperty... includedProperties);

        /**
         * <p>
         * Specifies optional fields that you want included in search results from this view. It is a list of objects
         * that each describe a field to include.
         * </p>
         * <p>
         * The default is an empty list, with no optional fields included in the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #includedProperties(List<IncludedProperty>)}.
         * 
         * @param includedProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourceexplorer2.model.IncludedProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #includedProperties(java.util.Collection<IncludedProperty>)
         */
        Builder includedProperties(Consumer<IncludedProperty.Builder>... includedProperties);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon resource name
         * (ARN)</a> of the view that you want to modify.
         * </p>
         * 
         * @param viewArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        resource name (ARN)</a> of the view that you want to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewArn(String viewArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceExplorer2Request.BuilderImpl implements Builder {
        private SearchFilter filters;

        private List<IncludedProperty> includedProperties = DefaultSdkAutoConstructList.getInstance();

        private String viewArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateViewRequest model) {
            super(model);
            filters(model.filters);
            includedProperties(model.includedProperties);
            viewArn(model.viewArn);
        }

        public final SearchFilter.Builder getFilters() {
            return filters != null ? filters.toBuilder() : null;
        }

        public final void setFilters(SearchFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(SearchFilter filters) {
            this.filters = filters;
            return this;
        }

        public final List<IncludedProperty.Builder> getIncludedProperties() {
            List<IncludedProperty.Builder> result = IncludedPropertyListCopier.copyToBuilder(this.includedProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncludedProperties(Collection<IncludedProperty.BuilderImpl> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copyFromBuilder(includedProperties);
        }

        @Override
        public final Builder includedProperties(Collection<IncludedProperty> includedProperties) {
            this.includedProperties = IncludedPropertyListCopier.copy(includedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(IncludedProperty... includedProperties) {
            includedProperties(Arrays.asList(includedProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includedProperties(Consumer<IncludedProperty.Builder>... includedProperties) {
            includedProperties(Stream.of(includedProperties).map(c -> IncludedProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getViewArn() {
            return viewArn;
        }

        public final void setViewArn(String viewArn) {
            this.viewArn = viewArn;
        }

        @Override
        public final Builder viewArn(String viewArn) {
            this.viewArn = viewArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateViewRequest build() {
            return new UpdateViewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
