/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricsExportStatusType {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    SUCCESS("Success"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricsExportStatusType> VALUE_MAP;
    private final String value;

    private MetricsExportStatusType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricsExportStatusType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricsExportStatusType> knownValues() {
        EnumSet<MetricsExportStatusType> knownValues = EnumSet.allOf(MetricsExportStatusType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricsExportStatusType.class, MetricsExportStatusType::toString);
    }
}

