/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AlarmReferenceIdListCopier;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationItem;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationItemListCopier;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationStatus;
import software.amazon.awssdk.services.resiliencehub.model.TestRisk;
import software.amazon.awssdk.services.resiliencehub.model.TestType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestRecommendation> {
    private static final SdkField<String> APP_COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appComponentId").getter(TestRecommendation.getter(TestRecommendation::appComponentId)).setter(TestRecommendation.setter(Builder::appComponentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentId").build()}).build();
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appComponentName").getter(TestRecommendation.getter(TestRecommendation::appComponentName)).setter(TestRecommendation.setter(Builder::appComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()}).build();
    private static final SdkField<List<String>> DEPENDS_ON_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependsOnAlarms").getter(TestRecommendation.getter(TestRecommendation::dependsOnAlarms)).setter(TestRecommendation.setter(Builder::dependsOnAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOnAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(TestRecommendation.getter(TestRecommendation::description)).setter(TestRecommendation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> INTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intent").getter(TestRecommendation.getter(TestRecommendation::intent)).setter(TestRecommendation.setter(Builder::intent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intent").build()}).build();
    private static final SdkField<List<RecommendationItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(TestRecommendation.getter(TestRecommendation::items)).setter(TestRecommendation.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TestRecommendation.getter(TestRecommendation::name)).setter(TestRecommendation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PREREQUISITE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prerequisite").getter(TestRecommendation.getter(TestRecommendation::prerequisite)).setter(TestRecommendation.setter(Builder::prerequisite)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prerequisite").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(TestRecommendation.getter(TestRecommendation::recommendationId)).setter(TestRecommendation.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final SdkField<String> RECOMMENDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationStatus").getter(TestRecommendation.getter(TestRecommendation::recommendationStatusAsString)).setter(TestRecommendation.setter(Builder::recommendationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationStatus").build()}).build();
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceId").getter(TestRecommendation.getter(TestRecommendation::referenceId)).setter(TestRecommendation.setter(Builder::referenceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceId").build()}).build();
    private static final SdkField<String> RISK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("risk").getter(TestRecommendation.getter(TestRecommendation::riskAsString)).setter(TestRecommendation.setter(Builder::risk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("risk").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(TestRecommendation.getter(TestRecommendation::typeAsString)).setter(TestRecommendation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_ID_FIELD, APP_COMPONENT_NAME_FIELD, DEPENDS_ON_ALARMS_FIELD, DESCRIPTION_FIELD, INTENT_FIELD, ITEMS_FIELD, NAME_FIELD, PREREQUISITE_FIELD, RECOMMENDATION_ID_FIELD, RECOMMENDATION_STATUS_FIELD, REFERENCE_ID_FIELD, RISK_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestRecommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appComponentId;
    private final String appComponentName;
    private final List<String> dependsOnAlarms;
    private final String description;
    private final String intent;
    private final List<RecommendationItem> items;
    private final String name;
    private final String prerequisite;
    private final String recommendationId;
    private final String recommendationStatus;
    private final String referenceId;
    private final String risk;
    private final String type;

    private TestRecommendation(BuilderImpl builder) {
        this.appComponentId = builder.appComponentId;
        this.appComponentName = builder.appComponentName;
        this.dependsOnAlarms = builder.dependsOnAlarms;
        this.description = builder.description;
        this.intent = builder.intent;
        this.items = builder.items;
        this.name = builder.name;
        this.prerequisite = builder.prerequisite;
        this.recommendationId = builder.recommendationId;
        this.recommendationStatus = builder.recommendationStatus;
        this.referenceId = builder.referenceId;
        this.risk = builder.risk;
        this.type = builder.type;
    }

    public final String appComponentId() {
        return this.appComponentId;
    }

    public final String appComponentName() {
        return this.appComponentName;
    }

    public final boolean hasDependsOnAlarms() {
        return this.dependsOnAlarms != null && !(this.dependsOnAlarms instanceof SdkAutoConstructList);
    }

    public final List<String> dependsOnAlarms() {
        return this.dependsOnAlarms;
    }

    public final String description() {
        return this.description;
    }

    public final String intent() {
        return this.intent;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<RecommendationItem> items() {
        return this.items;
    }

    public final String name() {
        return this.name;
    }

    public final String prerequisite() {
        return this.prerequisite;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final RecommendationStatus recommendationStatus() {
        return RecommendationStatus.fromValue(this.recommendationStatus);
    }

    public final String recommendationStatusAsString() {
        return this.recommendationStatus;
    }

    public final String referenceId() {
        return this.referenceId;
    }

    public final TestRisk risk() {
        return TestRisk.fromValue(this.risk);
    }

    public final String riskAsString() {
        return this.risk;
    }

    public final TestType type() {
        return TestType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependsOnAlarms() ? this.dependsOnAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.intent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.prerequisite());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.riskAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRecommendation)) {
            return false;
        }
        TestRecommendation other = (TestRecommendation)obj;
        return Objects.equals(this.appComponentId(), other.appComponentId()) && Objects.equals(this.appComponentName(), other.appComponentName()) && this.hasDependsOnAlarms() == other.hasDependsOnAlarms() && Objects.equals(this.dependsOnAlarms(), other.dependsOnAlarms()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.intent(), other.intent()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.prerequisite(), other.prerequisite()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.recommendationStatusAsString(), other.recommendationStatusAsString()) && Objects.equals(this.referenceId(), other.referenceId()) && Objects.equals(this.riskAsString(), other.riskAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TestRecommendation").add("AppComponentId", (Object)this.appComponentId()).add("AppComponentName", (Object)this.appComponentName()).add("DependsOnAlarms", this.hasDependsOnAlarms() ? this.dependsOnAlarms() : null).add("Description", (Object)this.description()).add("Intent", (Object)this.intent()).add("Items", this.hasItems() ? this.items() : null).add("Name", (Object)this.name()).add("Prerequisite", (Object)this.prerequisite()).add("RecommendationId", (Object)this.recommendationId()).add("RecommendationStatus", (Object)this.recommendationStatusAsString()).add("ReferenceId", (Object)this.referenceId()).add("Risk", (Object)this.riskAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appComponentId": {
                return Optional.ofNullable(clazz.cast(this.appComponentId()));
            }
            case "appComponentName": {
                return Optional.ofNullable(clazz.cast(this.appComponentName()));
            }
            case "dependsOnAlarms": {
                return Optional.ofNullable(clazz.cast(this.dependsOnAlarms()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "intent": {
                return Optional.ofNullable(clazz.cast(this.intent()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "prerequisite": {
                return Optional.ofNullable(clazz.cast(this.prerequisite()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "recommendationStatus": {
                return Optional.ofNullable(clazz.cast(this.recommendationStatusAsString()));
            }
            case "referenceId": {
                return Optional.ofNullable(clazz.cast(this.referenceId()));
            }
            case "risk": {
                return Optional.ofNullable(clazz.cast(this.riskAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appComponentId", APP_COMPONENT_ID_FIELD);
        map.put("appComponentName", APP_COMPONENT_NAME_FIELD);
        map.put("dependsOnAlarms", DEPENDS_ON_ALARMS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("intent", INTENT_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("prerequisite", PREREQUISITE_FIELD);
        map.put("recommendationId", RECOMMENDATION_ID_FIELD);
        map.put("recommendationStatus", RECOMMENDATION_STATUS_FIELD);
        map.put("referenceId", REFERENCE_ID_FIELD);
        map.put("risk", RISK_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestRecommendation, T> g) {
        return obj -> g.apply((TestRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appComponentId;
        private String appComponentName;
        private List<String> dependsOnAlarms = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String intent;
        private List<RecommendationItem> items = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String prerequisite;
        private String recommendationId;
        private String recommendationStatus;
        private String referenceId;
        private String risk;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRecommendation model) {
            this.appComponentId(model.appComponentId);
            this.appComponentName(model.appComponentName);
            this.dependsOnAlarms(model.dependsOnAlarms);
            this.description(model.description);
            this.intent(model.intent);
            this.items(model.items);
            this.name(model.name);
            this.prerequisite(model.prerequisite);
            this.recommendationId(model.recommendationId);
            this.recommendationStatus(model.recommendationStatus);
            this.referenceId(model.referenceId);
            this.risk(model.risk);
            this.type(model.type);
        }

        public final String getAppComponentId() {
            return this.appComponentId;
        }

        public final void setAppComponentId(String appComponentId) {
            this.appComponentId = appComponentId;
        }

        @Override
        public final Builder appComponentId(String appComponentId) {
            this.appComponentId = appComponentId;
            return this;
        }

        public final String getAppComponentName() {
            return this.appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final Collection<String> getDependsOnAlarms() {
            if (this.dependsOnAlarms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dependsOnAlarms;
        }

        public final void setDependsOnAlarms(Collection<String> dependsOnAlarms) {
            this.dependsOnAlarms = AlarmReferenceIdListCopier.copy(dependsOnAlarms);
        }

        @Override
        public final Builder dependsOnAlarms(Collection<String> dependsOnAlarms) {
            this.dependsOnAlarms = AlarmReferenceIdListCopier.copy(dependsOnAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOnAlarms(String ... dependsOnAlarms) {
            this.dependsOnAlarms(Arrays.asList(dependsOnAlarms));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIntent() {
            return this.intent;
        }

        public final void setIntent(String intent) {
            this.intent = intent;
        }

        @Override
        public final Builder intent(String intent) {
            this.intent = intent;
            return this;
        }

        public final List<RecommendationItem.Builder> getItems() {
            List<RecommendationItem.Builder> result = RecommendationItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<RecommendationItem.BuilderImpl> items) {
            this.items = RecommendationItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<RecommendationItem> items) {
            this.items = RecommendationItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(RecommendationItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<RecommendationItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (RecommendationItem)((RecommendationItem.Builder)RecommendationItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPrerequisite() {
            return this.prerequisite;
        }

        public final void setPrerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
        }

        @Override
        public final Builder prerequisite(String prerequisite) {
            this.prerequisite = prerequisite;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getRecommendationStatus() {
            return this.recommendationStatus;
        }

        public final void setRecommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
        }

        @Override
        public final Builder recommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        @Override
        public final Builder recommendationStatus(RecommendationStatus recommendationStatus) {
            this.recommendationStatus(recommendationStatus == null ? null : recommendationStatus.toString());
            return this;
        }

        public final String getReferenceId() {
            return this.referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getRisk() {
            return this.risk;
        }

        public final void setRisk(String risk) {
            this.risk = risk;
        }

        @Override
        public final Builder risk(String risk) {
            this.risk = risk;
            return this;
        }

        @Override
        public final Builder risk(TestRisk risk) {
            this.risk(risk == null ? null : risk.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TestType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public TestRecommendation build() {
            return new TestRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestRecommendation> {
        public Builder appComponentId(String var1);

        public Builder appComponentName(String var1);

        public Builder dependsOnAlarms(Collection<String> var1);

        public Builder dependsOnAlarms(String ... var1);

        public Builder description(String var1);

        public Builder intent(String var1);

        public Builder items(Collection<RecommendationItem> var1);

        public Builder items(RecommendationItem ... var1);

        public Builder items(Consumer<RecommendationItem.Builder> ... var1);

        public Builder name(String var1);

        public Builder prerequisite(String var1);

        public Builder recommendationId(String var1);

        public Builder recommendationStatus(String var1);

        public Builder recommendationStatus(RecommendationStatus var1);

        public Builder referenceId(String var1);

        public Builder risk(String var1);

        public Builder risk(TestRisk var1);

        public Builder type(String var1);

        public Builder type(TestType var1);
    }
}

