/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListMetricsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListMetricsResponse;

public class ListMetricsIterable
implements SdkIterable<ListMetricsResponse> {
    private final ResiliencehubClient client;
    private final ListMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMetricsIterable(ResiliencehubClient client, ListMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMetricsResponseFetcher();
    }

    public Iterator<ListMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<List<String>> rows() {
        Function<ListMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rows() != null) {
                return response.rows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMetricsResponseFetcher
    implements SyncPageFetcher<ListMetricsResponse> {
        private ListMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMetricsResponse nextPage(ListMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricsIterable.this.client.listMetrics(ListMetricsIterable.this.firstRequest);
            }
            return ListMetricsIterable.this.client.listMetrics((ListMetricsRequest)((Object)ListMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

